SELECT prd.PRODUKT_ID,
       prd.NAME,
       prd.PREIS,
       prd.LAGER_ID,
       lag.PLZ,
       lag.ORT
FROM   PRODUKT prd
       LEFT OUTER JOIN
       LAGER lag
       ON prd.LAGER_ID = lag.LAGER_ID
WHERE  prd.PREIS >= 20;



SELECT k.KATEGORIE,
       count(*) as ANZAHL_PRODUKTE,
       avg(p.PREIS) as DRUCHSCHNITTS_PREIS
FROM   PRODUKT p
       LEFT OUTER JOIN
       KATEGORIE k
       ON p.KATEGORIE_ID = k.KATEGORIE_ID
GROUP BY k.KATEGORIE;



SELECT kat.KATEGORIE_ID,
       kat.KATEGORIE,
       prd.PRODUKT_ID,
       prd.NAME,
       prd.PREIS
FROM   PRODUKT prd
       INNER JOIN
       (
          SELECT KATEGORIE_ID,
                 MIN(PREIS) as MIN_PREIS
          FROM   PRODUKT
          GROUP BY KATEGORIE_ID
       ) mpr
       ON prd.KATEGORIE_ID = mpr.KATEGORIE_ID AND
          prd.PREIS = mpr.MIN_PREIS
       INNER JOIN 
       KATEGORIE kat
       ON prd.KATEGORIE_ID = kat.KATEGORIE_ID;