DROP TABLE Zug.dbo.KUNDE;
DROP TABLE Zug.dbo.WAGON;
DROP TABLE Zug.dbo.ZUG;

CREATE TABLE Zug.dbo.ZUG
(
	ZUG_ID     int          NOT NULL,
    VON        varchar(30)  NOT NULL,
    NACH       varchar(30)  NOT NULL,
    CONSTRAINT ZUG_PK PRIMARY KEY (ZUG_ID)
);

CREATE TABLE Zug.dbo.WAGON
(
	WAGON_ID      int       NOT NULL,
	KLASSE        int       NOT NULL,
    ANZAHL_PLATZ  int       NOT NULL,
	ZUG_ID        int,
    CONSTRAINT WAGON_PK PRIMARY KEY (WAGON_ID)
);

CREATE TABLE Zug.dbo.KUNDE
(
	KUNDE_ID      int       NOT NULL,
	NAME          varchar(30)  NOT NULL,
	WAGON_ID      int
    CONSTRAINT KUNDE_PK PRIMARY KEY (KUNDE_ID)
);

ALTER TABLE Zug.dbo.WAGON ADD CONSTRAINT WAGON_FK
FOREIGN KEY (ZUG_ID) REFERENCES Zug.dbo.ZUG(ZUG_ID);

ALTER TABLE Zug.dbo.KUNDE ADD CONSTRAINT KUNDE_FK
FOREIGN KEY (WAGON_ID) REFERENCES Zug.dbo.WAGON(WAGON_ID);

INSERT INTO Zug.dbo.ZUG VALUES (11, 'Wien',  'Baden');
INSERT INTO Zug.dbo.ZUG VALUES (12, 'Baden', 'Mödling');
INSERT INTO Zug.dbo.ZUG VALUES (13, 'Wien',  'Linz');

INSERT INTO Zug.dbo.WAGON VALUES (1, 1, 2, 11);
INSERT INTO Zug.dbo.WAGON VALUES (2, 2, 2, 11);
INSERT INTO Zug.dbo.WAGON VALUES (3, 2, 3, 11);

INSERT INTO Zug.dbo.WAGON VALUES (4, 2, 2, 12);
INSERT INTO Zug.dbo.WAGON VALUES (5, 2, 2, 12);

INSERT INTO Zug.dbo.KUNDE VALUES (51, 'Susi',   3);
INSERT INTO Zug.dbo.KUNDE VALUES (52, 'Max',    3);
INSERT INTO Zug.dbo.KUNDE VALUES (53, 'Fritz',  3);
INSERT INTO Zug.dbo.KUNDE VALUES (54, 'Alex',   4);
INSERT INTO Zug.dbo.KUNDE VALUES (55, 'Hans',   2);
INSERT INTO Zug.dbo.KUNDE VALUES (56, 'Werner', 1);
INSERT INTO Zug.dbo.KUNDE VALUES (57, 'Karl',   2);
INSERT INTO Zug.dbo.KUNDE VALUES (58, 'Maria',  NULL);
