ALTER TABLE Firma.dbo.MITARBEITER
DROP CONSTRAINT MITARBEITER_FK;

ALTER TABLE Firma.dbo.GEHALT
DROP CONSTRAINT GEHALT_FK;

DROP TABLE Firma.dbo.MITARBEITER;

CREATE TABLE Firma.dbo.MITARBEITER
(
	MITARBEITER_ID       INT                         NOT NULL,
	VORNAME              VARCHAR(30)                 NOT NULL,
	GEBURTSDATUM         DATE                        NOT NULL,
	BOSS_ID              INT,
	CONSTRAINT MITARBEITER_PK PRIMARY KEY (MITARBEITER_ID)
);

ALTER TABLE Firma.dbo.MITARBEITER ADD CONSTRAINT MITARBEITER_FK
FOREIGN KEY (BOSS_ID)
REFERENCES Firma.dbo.MITARBEITER (MITARBEITER_ID);


/*
 *                          Max
 *           Susi                                Franz
 *    Max          Alex                Maria             Andrea
*/


INSERT INTO Firma.dbo.MITARBEITER VALUES (1, 'Max',    '1989-10-20', NULL);
INSERT INTO Firma.dbo.MITARBEITER VALUES (2, 'Susi',   '1992-10-20', 1);
INSERT INTO Firma.dbo.MITARBEITER VALUES (3, 'Franz',  '1975-10-20', 1);
INSERT INTO Firma.dbo.MITARBEITER VALUES (4, 'Max',    '1986-10-20', 2);
INSERT INTO Firma.dbo.MITARBEITER VALUES (5, 'Alex',   '1987-10-20', 2);
INSERT INTO Firma.dbo.MITARBEITER VALUES (6, 'Maria',  '1981-10-20', 3);
INSERT INTO Firma.dbo.MITARBEITER VALUES (7, 'Andrea', '1980-10-20', 3);



DROP TABLE Firma.dbo.GEHALT;

CREATE TABLE Firma.dbo.GEHALT
(
	MITARBEITER_ID       INT           NOT NULL,
	RECORD_START_DATE    DATE          NOT NULL,
	RECORD_END_DATE      DATE          NOT NULL,
	GEHALT               DECIMAL(10,2),
	CONSTRAINT GEHALT_PK PRIMARY KEY (MITARBEITER_ID, RECORD_START_DATE)
);

ALTER TABLE Firma.dbo.GEHALT ADD CONSTRAINT GEHALT_FK
FOREIGN KEY (MITARBEITER_ID)
REFERENCES Firma.dbo.MITARBEITER (MITARBEITER_ID);


/*
 * 2   10.1.   14.2.   2000
 * 2   15.2.   29.4.   2400
 * 2   30.4.   31.12.  2600
 */

INSERT INTO Firma.dbo.GEHALT VALUES (1, '2000-10-29', '9999-12-31', 4500);
INSERT INTO Firma.dbo.GEHALT VALUES (2, '2002-11-21', '9999-12-31', 3900);
INSERT INTO Firma.dbo.GEHALT VALUES (3, '2012-09-06', '2012-09-16', 3700);
INSERT INTO Firma.dbo.GEHALT VALUES (3, '2012-09-17', '2012-11-29', 3800);
INSERT INTO Firma.dbo.GEHALT VALUES (3, '2012-11-30', '9999-12-31', 4200);
INSERT INTO Firma.dbo.GEHALT VALUES (4, '2020-02-16', '9999-12-31', 2600);
INSERT INTO Firma.dbo.GEHALT VALUES (5, '2002-01-17', '9999-12-31', 2800);
INSERT INTO Firma.dbo.GEHALT VALUES (6, '2005-07-05', '9999-12-31', 2700);
INSERT INTO Firma.dbo.GEHALT VALUES (7, '2021-12-09', '2023-02-16', 2500);
INSERT INTO Firma.dbo.GEHALT VALUES (7, '2023-02-17', '9999-12-31', 2800);