/*****/
/* 2 */
/*****/

CREATE TABLE GRIESMAYER_ACCOUNTS
(
  ACCOUNT_ID         INTEGER      NOT NULL PRIMARY KEY,
  FIRST_NAME         VARCHAR(15)  NOT NULL,
  LAST_TRANSACTION   DATE         NOT NULL,
  BALANCE            DECIMAL(8,2) NOT NULL,
  CREDIT_LIMIT       DECIMAL(8,2) NOT NULL
);

DELETE FROM   GRIESMAYER_ACCOUNTS;

CREATE SEQUENCE SEQ_ACCOUNT_ID
   START WITH     1000
   INCREMENT BY   1
   CACHE          20;
COMMIT;

SELECT SEQ_ACCOUNT_ID.nextval
FROM   DUAL;

CREATE OR REPLACE TRIGGER TRG_GRIESMAYER_ACCOUNTS
BEFORE INSERT or UPDATE on GRIESMAYER_ACCOUNTS
FOR EACH ROW
BEGIN
  IF (INSERTING) THEN
    SELECT SEQ_ACCOUNT_ID.nextval INTO :new.ACCOUNT_ID
    FROM   DUAL;

    IF ((:new.CREDIT_LIMIT is NULL) or (:new.CREDIT_LIMIT > 0)) THEN
      SELECT -1000 INTO :new.CREDIT_LIMIT
      FROM   DUAL;
    END IF;
  END IF;

  IF (UPDATING) THEN
    IF (:old.ACCOUNT_ID <> :new.ACCOUNT_ID) THEN
      raise_application_error (-20998, 'Cannot change the ACCOUNT_ID!');
    END IF;

    IF (abs(:new.BALANCE - :old.BALANCE) > 1000) THEN
      raise_application_error (-20997, 'The transaction is limited by 1000€!');
    END IF;
  END IF;

  SELECT SYSDATE INTO :new.LAST_TRANSACTION
  FROM   DUAL;

  IF (:new.BALANCE < :new.CREDIT_LIMIT) THEN
    raise_application_error (-20999, 'The balance ' || :new.BALANCE || ' is under the credit limit' || :new.CREDIT_LIMIT || '!');
  END IF;
END;

SELECT *
FROM   GRIESMAYER_ACCOUNTS;

INSERT INTO GRIESMAYER_ACCOUNTS VALUES (-555, 'Fritz', NULL, 500, -2000);
INSERT INTO GRIESMAYER_ACCOUNTS VALUES (1030, 'Hugo',  NULL, -4000, -2000);
INSERT INTO GRIESMAYER_ACCOUNTS VALUES (1030, 'Susi',  NULL, 200, NULL);
INSERT INTO GRIESMAYER_ACCOUNTS VALUES (1030, 'Alex',  TO_DATE('1975-08-20', 'yyyy-mm-dd'), 200, 5000);

SELECT *
FROM   GRIESMAYER_ACCOUNTS

UPDATE GRIESMAYER_ACCOUNTS
SET    ACCOUNT_ID = 77
WHERE  ACCOUNT_ID = 1006;

UPDATE GRIESMAYER_ACCOUNTS
SET    BALANCE = 0
WHERE  ACCOUNT_ID = 1006;

UPDATE GRIESMAYER_ACCOUNTS
SET    BALANCE = -1000
WHERE  ACCOUNT_ID = 1006;

UPDATE GRIESMAYER_ACCOUNTS
SET    BALANCE = -2000
WHERE  ACCOUNT_ID = 1006;

UPDATE GRIESMAYER_ACCOUNTS
SET    BALANCE = -3000
WHERE  ACCOUNT_ID = 1006;

UPDATE GRIESMAYER_ACCOUNTS
SET    BALANCE = 4000
WHERE  ACCOUNT_ID = 1006;
