/******/
/* 02 */
/******/

DROP TABLE GRIESMAYER_CREDIT_LIMITS;

CREATE TABLE GRIESMAYER_CREDIT_LIMITS
(
  CREDIT_LIMIT              CHAR(1)      NOT NULL PRIMARY KEY,
  CREDIT_LIMIT_AMOUNT       DECIMAL(8,2) NOT NULL CONSTRAINT limit_negative CHECK (CREDIT_LIMIT_AMOUNT <= 0)
);

INSERT INTO GRIESMAYER_CREDIT_LIMITS VALUES ('X',  4000);

INSERT INTO GRIESMAYER_CREDIT_LIMITS VALUES ('A',    -0);
INSERT INTO GRIESMAYER_CREDIT_LIMITS VALUES ('B', -1000);
INSERT INTO GRIESMAYER_CREDIT_LIMITS VALUES ('C', -2000);
COMMIT;

DROP TABLE GRIESMAYER_ACCOUNTS;

CREATE TABLE GRIESMAYER_ACCOUNTS
(
  ACCOUNT_ID   INTEGER      NOT NULL PRIMARY KEY,
  FIRST_NAME   VARCHAR(15)  NOT NULL CHECK (REGEXP_LIKE(FIRST_NAME,'^[A-Z][a-zA-Z ]*$')),
  CREDIT_LIMIT CHAR(1),
  AMOUNT       DECIMAL(8,2) NOT NULL,
  FOREIGN KEY (CREDIT_LIMIT)
      REFERENCES GRIESMAYER_CREDIT_LIMITS(CREDIT_LIMIT)
);

INSERT INTO GRIESMAYER_ACCOUNTS VALUES (1, 'Max',    'A',    100.00);
INSERT INTO GRIESMAYER_ACCOUNTS VALUES (2, 'Thomas', 'Z',    100.00);
INSERT INTO GRIESMAYER_ACCOUNTS VALUES (2, 'Thomas', 'A',   -100.00);
INSERT INTO GRIESMAYER_ACCOUNTS VALUES (3, 'Andrea', 'B',   -100.00);
INSERT INTO GRIESMAYER_ACCOUNTS VALUES (4, 'Verena', 'B',  -1100.00);
INSERT INTO GRIESMAYER_ACCOUNTS VALUES (5, 'Gudrun', 'B',      NULL);

COMMIT;

SELECT *
FROM   USER_CONSTRAINTS;

