CREATE OR REPLACE FUNCTION PROC_BOARDING
	(
		v_CUSTOMER_ID			IN  CUSTOMER.CUSTOMER_ID%TYPE,
		v_STATION_FROM        IN  TRAIN.STATION_FROM%TYPE,
		v_STATION_TO          IN	TRAIN.STATION_TO%TYPE,
        v_DEPATURE_TIME       OUT	TRAIN.DEPATURE_TIME%TYPE
	)
	RETURN INTEGER
AS
	v_TICKET_ID		INTEGER;
	v_PRICE			DECIMAL(10,2);
	v_WAGON_ID		INTEGER;
	v_ERROR_MESSAGE	VARCHAR(200);
	v_OK			INTEGER;
BEGIN
	v_TICKET_ID := SEQ_TICKET_ID.NEXTVAL;

	SELECT trn.DEPATURE_TIME,
	       (CASE
		       WHEN cus.FIRST_CLASS = 'Y' THEN trn.PRICE_FIRST
		       ELSE                            trn.PRICE_SECOND
	       	END
	       ) AS PRICE,
	       wag.WAGON_ID
	INTO   v_DEPATURE_TIME,
	       v_PRICE,
	       v_WAGON_ID
	FROM   TRAIN trn
	       INNER JOIN
	       WAGON wag
	       ON wag.TRAIN_ID = trn.TRAIN_ID
	       LEFT OUTER JOIN
	       (
	          SELECT WAGON_ID,
	                 COUNT(*) AS SEATS_OCCUPIED 
	          FROM   CUSTOMER                  
	          GROUP BY WAGON_ID       
	       ) occ
	       ON wag.WAGON_ID = occ.WAGON_ID
	       INNER JOIN
	       (
	          SELECT *
	          FROM   CUSTOMER
	          WHERE  CUSTOMER_ID = v_CUSTOMER_ID AND
	                 WAGON_ID IS NULL
	       ) cus
	       ON (   (cus.FIRST_CLASS = 'Y' AND wag.WAGON_CLASS = 1) OR
	              (cus.FIRST_CLASS = 'N' AND wag.WAGON_CLASS = 2)   )
	WHERE  STATION_FROM = v_STATION_FROM AND
		   STATION_TO = v_STATION_TO AND
		   DEPATURE_TIME >= (TO_CHAR(SYSDATE, 'HH24')*100+
	                         TO_CHAR(SYSDATE, 'MI')) AND
	       wag.SEATS > NVL(occ.SEATS_OCCUPIED, 0) AND
	       cus.CASH >= (CASE
		                  WHEN cus.FIRST_CLASS = 'Y' THEN trn.PRICE_FIRST
		                  ELSE                            trn.PRICE_SECOND
	       	           END)
	ORDER BY DEPATURE_TIME
	FETCH FIRST 1 ROW ONLY;

	UPDATE CUSTOMER
	SET    CASH = CASH - v_PRICE,
	       WAGON_ID = v_WAGON_ID
	WHERE  CUSTOMER_ID = v_CUSTOMER_ID;

	INSERT INTO TICKET VALUES(v_TICKET_ID,
						      v_CUSTOMER_ID,
						      SYSDATE,
						      v_PRICE,
						      'Y');

	COMMIT;

	RETURN v_TICKET_ID;
EXCEPTION
	WHEN NO_DATA_FOUND THEN
		ROLLBACK;
		/*Is the CUSTOMER_ID valid?*/
		SELECT count(*)
		INTO   v_OK
		FROM   CUSTOMER
		WHERE  CUSTOMER_ID = v_CUSTOMER_ID;
		IF v_OK <> 1 THEN
			Raise_application_error(-20301, 'Error: Customer_ID not valid!');
		END IF;
	
		/*Is the customer currently not in a train?*/
		SELECT count(*)
		INTO   v_OK
		FROM   CUSTOMER
		WHERE  CUSTOMER_ID = v_CUSTOMER_ID AND
	           WAGON_ID IS NULL;
		IF v_OK <> 1 THEN
			Raise_application_error(-20302, 'Error: Customer is already in a train!');
		END IF;
	
		/*Is there a train after the current time?*/
		SELECT count(*)
		INTO   v_OK
		FROM   TRAIN
		WHERE  STATION_FROM = v_STATION_FROM AND
		       STATION_TO = v_STATION_TO AND
	           DEPATURE_TIME >= (TO_CHAR(SYSDATE, 'HH24')*100+
	                             TO_CHAR(SYSDATE, 'MI'));
		IF v_OK = 0 THEN
			Raise_application_error(-20303, 'Error: No train!');
		END IF;
	
		/*Is there a seat (WAGON_CLASS) left in the train?*/
		SELECT count(*)
		INTO   v_OK
		FROM   TRAIN trn
		       INNER JOIN
		       WAGON wag
		       ON wag.TRAIN_ID = trn.TRAIN_ID
		       LEFT OUTER JOIN
		       (
		          SELECT WAGON_ID,
		                 COUNT(*) AS SEATS_OCCUPIED 
		          FROM   CUSTOMER                  
		          GROUP BY WAGON_ID       
		       ) occ
		       ON wag.WAGON_ID = occ.WAGON_ID
		       INNER JOIN
		       (
		          SELECT *
		          FROM   CUSTOMER
		          WHERE  CUSTOMER_ID = v_CUSTOMER_ID AND
		                 WAGON_ID IS NULL
		       ) cus
		       ON (   (cus.FIRST_CLASS = 'Y' AND wag.WAGON_CLASS = 1) OR
		              (cus.FIRST_CLASS = 'N' AND wag.WAGON_CLASS = 2)   )
		WHERE  STATION_FROM = v_STATION_FROM AND
			   STATION_TO = v_STATION_TO AND
			   DEPATURE_TIME >= (TO_CHAR(SYSDATE, 'HH24')*100+
		                         TO_CHAR(SYSDATE, 'MI')) AND
		       wag.SEATS > NVL(occ.SEATS_OCCUPIED, 0);
		IF v_OK = 0 THEN
			Raise_application_error(-20304, 'Error: No seat left!');
		END IF;
	
		Raise_application_error(-20305, 'Error: no money!');
END;