CREATE OR REPLACE FUNCTION THOMAS.PROC_MONEY_TRANSFER
	(
		p_ACCOUNT_ID_FROM	IN  MONEY_TRANSFER.ACCOUNT_ID_FROM%TYPE,
		p_ACCOUNT_ID_TO   	IN  MONEY_TRANSFER.ACCOUNT_ID_TO%TYPE,
		p_TRANSFERDATE		OUT MONEY_TRANSFER.TRANSFERDATE%TYPE,
		p_AMOUNT            IN  MONEY_TRANSFER.AMOUNT%TYPE
	)
	RETURN INTEGER
AS
	v_TRANSFER_ID	INTEGER;
	v_ERROR_MESSAGE	VARCHAR(200);
BEGIN
	v_TRANSFER_ID := SEQ_TRANSFER_ID.NEXTVAL;
	p_TRANSFERDATE := SYSDATE();

	UPDATE BANK_ACCOUNT
	SET    BALANCE = BALANCE - p_AMOUNT
	WHERE  ACCOUNT_ID = p_ACCOUNT_ID_FROM;

	IF SQL%NOTFOUND THEN
		ROLLBACK;
		v_ERROR_MESSAGE := 'Fehler: Account_ID nicht vorhanden ' || p_ACCOUNT_ID_FROM;
		INSERT INTO MONEY_TRANSFER_NOTALLOWED VALUES
			(v_TRANSFER_ID, p_ACCOUNT_ID_FROM,
   			 p_ACCOUNT_ID_TO, p_TRANSFERDATE , p_AMOUNT,
   			 v_ERROR_MESSAGE);
		COMMIT;
		Raise_application_error(-20201, v_ERROR_MESSAGE);
	END IF;



	UPDATE BANK_ACCOUNT
	SET    BALANCE = BALANCE - p_AMOUNT
	WHERE  ACCOUNT_ID = p_ACCOUNT_ID_TO;

	IF SQL%NOTFOUND THEN
		ROLLBACK;
		v_ERROR_MESSAGE := 'Fehler: Account_ID nicht vorhanden ' || p_ACCOUNT_ID_TO;
		INSERT INTO MONEY_TRANSFER_NOTALLOWED VALUES
			(v_TRANSFER_ID, p_ACCOUNT_ID_FROM,
   			 p_ACCOUNT_ID_TO, p_TRANSFERDATE , p_AMOUNT,
   			 v_ERROR_MESSAGE);
		COMMIT;
		Raise_application_error(-20202, v_ERROR_MESSAGE);
	END IF;



	INSERT INTO MONEY_TRANSFER VALUES
	(v_TRANSFER_ID, p_ACCOUNT_ID_FROM,
     p_ACCOUNT_ID_TO, p_TRANSFERDATE , p_AMOUNT);
	COMMIT;


	RETURN v_TRANSFER_ID;
END;