DROP TABLE BANK_ACCOUNT;

CREATE TABLE BANK_ACCOUNT
(
	ACCOUNT_ID		INTEGER 		NOT NULL	PRIMARY KEY,
	FIRST_NAME		VARCHAR(30) 	NOT NULL,
	BIRTHDATE		DATE			NOT NULL,
	BALANCE			DECIMAL(10,2)	NOT NULL,
	CREDIT_LIMIT	DECIMAL(10,2)	NOT NULL
);

INSERT INTO BANK_ACCOUNT VALUES (1, 'Max',    '20-DEC-89', 1000,     0);
INSERT INTO BANK_ACCOUNT VALUES (2, 'Susi',   '17-JAN-92',    0, -1000);
INSERT INTO BANK_ACCOUNT VALUES (3, 'Alex',   '23-FEB-02',  100,     0);
INSERT INTO BANK_ACCOUNT VALUES (4, 'Andrea', '15-APR-73',  700, -1000);
INSERT INTO BANK_ACCOUNT VALUES (5, 'Verena', '08-DEC-69', 4600, -2000);
INSERT INTO BANK_ACCOUNT VALUES (6, 'Marion', '12-MAR-71', 6000, -2000);
INSERT INTO BANK_ACCOUNT VALUES (7, 'Hans',   '14-JUN-75', 7000,     0);

DROP SEQUENCE SEQ_TRANSFER_ID;

CREATE SEQUENCE SEQ_TRANSFER_ID
	START WITH	 1000
	INCREMENT BY    1
	NOCACHE;


DROP TABLE MONEY_TRANSFER;

CREATE TABLE MONEY_TRANSFER
(
	TRANSFER_ID				INTEGER			NOT NULL	PRIMARY KEY,
	ACCOUNT_ID_FROM			INTEGER			NOT NULL,
	ACCOUNT_ID_TO			INTEGER			NOT NULL,
	TRANSFERDATE			DATE			NOT NULL,
	AMOUNT					DECIMAL(10,2)	NOT NULL
);


DROP TABLE MONEY_TRANSFER_NOTALLOWED;

CREATE TABLE MONEY_TRANSFER_NOTALLOWED
(
	TRANSFER_ID				INTEGER			NOT NULL	PRIMARY KEY,
	ACCOUNT_ID_FROM			INTEGER			NOT NULL,
	ACCOUNT_ID_TO			INTEGER			NOT NULL,
	TRANSFERDATE			DATE			NOT NULL,
	AMOUNT					DECIMAL(10,2)	NOT NULL,
	REASON 					VARCHAR(1000)
);

DROP TABLE TRANSFERS_TODO;

CREATE TABLE TRANSFERS_TODO
(
	TRANSFERS_TODO_ID		INTEGER			NOT NULL    PRIMARY KEY,
	ACCOUNT_ID_FROM			INTEGER			NOT NULL,
	ACCOUNT_ID_TO			INTEGER			NOT NULL,
	AMOUNT					DECIMAL(10,2)	NOT NULL,
	TRANSFER_PROCESSED      CHAR(1),
	TRANSFER_ID				INTEGER
);

INSERT INTO TRANSFERS_TODO VALUES(100,  1, 4,   100,'N',NULL);
INSERT INTO TRANSFERS_TODO VALUES(101,  2, 4,   200,'N',NULL);
INSERT INTO TRANSFERS_TODO VALUES(102,  5, 4,    50,'N',NULL);
INSERT INTO TRANSFERS_TODO VALUES(103, 99, 4,   400,'N',NULL);
INSERT INTO TRANSFERS_TODO VALUES(104,  3, 4,   100,'N',NULL);
INSERT INTO TRANSFERS_TODO VALUES(105,  2, 4,500000,'N',NULL);
INSERT INTO TRANSFERS_TODO VALUES(106,  7,99,    80,'N',NULL);


COMMIT;