CREATE OR REPLACE FUNCTION PROC_MONEY_TRANSFER
	(
		p_ACCOUNT_ID_FROM	IN  MONEY_TRANSFER.ACCOUNT_ID_FROM%TYPE,
		p_ACCOUNT_ID_TO   	IN  MONEY_TRANSFER.ACCOUNT_ID_TO%TYPE,
		p_TRANSFERDATE		OUT MONEY_TRANSFER.TRANSFERDATE%TYPE,
		p_AMOUNT            IN  MONEY_TRANSFER.AMOUNT%TYPE
	)
	RETURN INTEGER
AS 
	v_COUNT			INTEGER;
	v_TRANSFER_ID	INTEGER;
BEGIN
	v_TRANSFER_ID := SEQ_TRANSFER_ID.NEXTVAL;
	p_TRANSFERDATE := SYSDATE();
	
	SELECT count(*)
	INTO   v_COUNT
	FROM   BANK_ACCOUNT
	WHERE  ACCOUNT_ID = p_ACCOUNT_ID_FROM;
	
	IF v_COUNT != 1 THEN
		dbms_output.put_line('Fehler: Account_ID nicht vorhanden ' || p_ACCOUNT_ID_FROM);
		GOTO fehler;
	END IF;
	
	UPDATE BANK_ACCOUNT
	SET    BALANCE = BALANCE - p_AMOUNT
	WHERE  ACCOUNT_ID = p_ACCOUNT_ID_FROM;



	SELECT count(*)
	INTO   v_COUNT
	FROM   BANK_ACCOUNT
	WHERE  ACCOUNT_ID = p_ACCOUNT_ID_TO;
	
	IF v_COUNT != 1 THEN
		dbms_output.put_line('Fehler: Account_ID nicht vorhanden ' || p_ACCOUNT_ID_TO);
		GOTO fehler;
	END IF;

	UPDATE BANK_ACCOUNT
	SET    BALANCE = BALANCE + p_AMOUNT
	WHERE  ACCOUNT_ID = p_ACCOUNT_ID_TO;

	INSERT INTO MONEY_TRANSFER VALUES
	(v_TRANSFER_ID, p_ACCOUNT_ID_FROM,
     p_ACCOUNT_ID_TO, p_TRANSFERDATE , p_AMOUNT);
     
	COMMIT;
	RETURN v_TRANSFER_ID;
	<<fehler>>
	ROLLBACK;
	INSERT INTO MONEY_TRANSFER_NOTALLOWED VALUES
	(v_TRANSFER_ID, p_ACCOUNT_ID_FROM,
     p_ACCOUNT_ID_TO, p_TRANSFERDATE , p_AMOUNT, 'Fehlermeldung!');
	COMMIT;
	RETURN NULL;
END;
