DECLARE
	CURSOR v_TODO IS
		SELECT *
		FROM   BOARDING
		WHERE  PROCESSED = 'N';
	v_DEPATURE_TIME INTEGER;
	v_TICKET_ID		INTEGER;
BEGIN
	FOR r_TODO IN v_TODO
	LOOP
		BEGIN
			v_TICKET_ID := PROC_BOARDING(r_TODO.CUSTOMER_ID,
		                                 r_TODO.STATION_FROM,
		                                 r_TODO.STATION_TO,
		                                 v_DEPATURE_TIME);
			dbms_output.put_line (v_TICKET_ID || '   ' || v_DEPATURE_TIME);
			UPDATE BOARDING
			SET    PROCESSED = 'Y',
			       TICKET_ID = v_TICKET_ID
			WHERE  BOARDING_ID = r_TODO.BOARDING_ID;
			COMMIT;
		EXCEPTION
			WHEN OTHERS THEN
				dbms_output.put_line(sqlerrm);
				UPDATE BOARDING
				SET    PROCESSED = 'Y'
				WHERE  BOARDING_ID = r_TODO.BOARDING_ID;
				COMMIT;
				CONTINUE;
		END;
	END LOOP;
END;