SELECT trn.TRAIN_ID,
       trn.DEPATURE_TIME,
       trn.STATION_FROM,
       trn.STATION_TO,
       trn.PRICE_FIRST,
       trn.PRICE_SECOND,
       (CASE
	       WHEN cus.FIRST_CLASS = 'Y' THEN trn.PRICE_FIRST
	       ELSE                            trn.PRICE_SECOND
       	END
       ) AS PRICE,
       wag.WAGON_ID,
       wag.WAGON_CLASS,
       wag.SEATS,
       NVL(occ.SEATS_OCCUPIED, 0) AS SEATS_OCCUPIED,
       cus.CUSTOMER_ID,
       cus.FIRSTNAME,
       cus.FIRST_CLASS,
       cus.CASH
FROM   TRAIN trn
       INNER JOIN
       WAGON wag
       ON wag.TRAIN_ID = trn.TRAIN_ID
       LEFT OUTER JOIN
       (
          SELECT WAGON_ID,
                 COUNT(*) AS SEATS_OCCUPIED 
          FROM   CUSTOMER                  
          GROUP BY WAGON_ID       
       ) occ
       ON wag.WAGON_ID = occ.WAGON_ID
       INNER JOIN
       (
          SELECT *
          FROM   CUSTOMER
          WHERE  CUSTOMER_ID = 100 AND
                 WAGON_ID IS NULL
       ) cus
       ON (   (cus.FIRST_CLASS = 'Y' AND wag.WAGON_CLASS = 1) OR
              (cus.FIRST_CLASS = 'N' AND wag.WAGON_CLASS = 2)   )
WHERE  STATION_FROM = 'Wien' AND
	   STATION_TO = 'Baden' AND
	   DEPATURE_TIME >= (TO_CHAR(SYSDATE, 'HH24')*100+
                         TO_CHAR(SYSDATE, 'MI')) AND
       wag.SEATS > NVL(occ.SEATS_OCCUPIED, 0) AND
       cus.CASH >= (CASE
	                  WHEN cus.FIRST_CLASS = 'Y' THEN trn.PRICE_FIRST
	                  ELSE                            trn.PRICE_SECOND
       	           END)
ORDER BY DEPATURE_TIME
FETCH FIRST 1 ROW ONLY