DROP TABLE TRAIN;

CREATE TABLE TRAIN
(
TRAIN_ID      INTEGER      PRIMARY KEY,
DEPATURE_TIME INTEGER,
STATION_FROM  VARCHAR(30),
STATION_TO    VARCHAR(30),
PRICE_FIRST   DECIMAL(6,2),
PRICE_SECOND  DECIMAL(6,2)
);

INSERT INTO TRAIN VALUES (500, 2355, 'Wien',  'Baden', 20, 12);
INSERT INTO TRAIN VALUES (501, 1800, 'Wien',  'Baden', 25, 18);
INSERT INTO TRAIN VALUES (502, 2357, 'Wien',  'Linz',  80, 65);
INSERT INTO TRAIN VALUES (503, 2340, 'Baden', 'Wien',  20, 12);



DROP TABLE WAGON;

CREATE TABLE WAGON
(
WAGON_ID      INTEGER      PRIMARY KEY,
WAGON_CLASS   INTEGER,
SEATS         INTEGER,
TRAIN_ID      INTEGER
);

INSERT INTO WAGON VALUES (1, 1, 2,500);
INSERT INTO WAGON VALUES (2, 2, 2,500);
INSERT INTO WAGON VALUES (3, 1, 2,501);
INSERT INTO WAGON VALUES (4, 2, 3,501);
INSERT INTO WAGON VALUES (5, 1, 3,502);
INSERT INTO WAGON VALUES (6, 2, 2,502);
INSERT INTO WAGON VALUES (7, 2, 3,502);
INSERT INTO WAGON VALUES (8, 2, 2,503);



DROP TABLE CUSTOMER;

CREATE TABLE CUSTOMER
(
CUSTOMER_ID   INTEGER      PRIMARY KEY,
FIRSTNAME     VARCHAR(30),
FIRST_CLASS   CHAR(1),
CASH          DECIMAL(10,2),
WAGON_ID      INTEGER
);

INSERT INTO CUSTOMER VALUES (100, 'Thomas', 'Y', 200, NULL);
INSERT INTO CUSTOMER VALUES (102, 'Susi',   'N', 200, NULL);
INSERT INTO CUSTOMER VALUES (103, 'Hans',   'Y',   0, NULL);
INSERT INTO CUSTOMER VALUES (104, 'Andrea', 'Y', 200, NULL);
INSERT INTO CUSTOMER VALUES (105, 'Marion', 'N', 200, NULL);
INSERT INTO CUSTOMER VALUES (106, 'Verena', 'Y', 200, NULL);
INSERT INTO CUSTOMER VALUES (107, 'Alex',   'N', 200, NULL);
INSERT INTO CUSTOMER VALUES (108, 'Karl',   'N', 200, NULL);
INSERT INTO CUSTOMER VALUES (109, 'Hans',   'N', 200, 4);
INSERT INTO CUSTOMER VALUES (110, 'Werner', 'N', 200, 4);



DROP TABLE TICKET;

CREATE TABLE TICKET
(
TICKET_ID   INTEGER        PRIMARY KEY,
CUSTOMER_ID INTEGER,
BUY_DATE    DATE,
PRICE       DECIMAL(6,2),
VALID       CHAR(1)
);

DROP SEQUENCE SEQ_TICKET_ID;

CREATE SEQUENCE SEQ_TICKET_ID
	START WITH	 1000
	INCREMENT BY    1
	NOCACHE;



DROP TABLE BOARDING;

CREATE TABLE BOARDING
(
BOARDING_ID		INTEGER      PRIMARY KEY,
CUSTOMER_ID		INTEGER,
STATION_FROM	VARCHAR(30),
STATION_TO		VARCHAR(30),
PROCESSED		CHAR(1),
TICKET_ID		INTEGER
);

INSERT INTO BOARDING VALUES (10, 100, 'Wien', 'Baden', 'N', NULL);
INSERT INTO BOARDING VALUES (11, 100, 'Wien', 'Baden', 'N', NULL);
INSERT INTO BOARDING VALUES (12, 101, 'Baden', 'Wien', 'N', NULL);
INSERT INTO BOARDING VALUES (13, 102, 'Wien', 'Tirol', 'N', NULL);
INSERT INTO BOARDING VALUES (14, 103, 'Wien', 'Linz',  'N', NULL);

COMMIT;
