CREATE OR REPLACE TRIGGER TRG_BANKACCOUNT
BEFORE INSERT OR UPDATE ON BANKACCOUNT
FOR EACH ROW
DECLARE
BEGIN
    IF (:NEW.AMOUNT < -:NEW.CREDITLIMIT) THEN
        RAISE_APPLICATION_ERROR (-20999, 'The balance ' || :NEW.AMOUNT || ' is over the credit limit ' || :NEW.CREDITLIMIT || '!');
    END IF;
    
    IF (UPDATING) THEN
        :NEW.OPENINGDATE := :OLD.OPENINGDATE;
        :NEW.ACCOUNTNUMBER := :OLD.ACCOUNTNUMBER;
    
        IF (abs(:NEW.AMOUNT - :OLD.AMOUNT) > 10000) THEN
            RAISE_APPLICATION_ERROR (-20998, 'Transactions over 10000 EUR are not allowed!');
        END IF;
    END IF;
END TRG_BANKACCOUNT;
