/*****/
/* 2 */
/*****/

DROP TABLE GRIESMAYER_ACCOUNTS;

CREATE TABLE GRIESMAYER_ACCOUNTS
(
  ACCOUNT_ID          INTEGER      NOT NULL PRIMARY KEY,
  FIRST_NAME          VARCHAR(15)  NOT NULL,
  LAST_TRANSACTION_ID INTEGER,
  BALANCE             DECIMAL(8,2) NOT NULL,
  CREDIT_LIMIT        DECIMAL(8,2) NOT NULL,
  MAX_BALANCE         DECIMAL(8,2) NOT NULL
);

DELETE FROM   GRIESMAYER_ACCOUNTS;



INSERT INTO GRIESMAYER_ACCOUNTS VALUES (1, 'Alex',   NULL,   200, -1000, 2000);
INSERT INTO GRIESMAYER_ACCOUNTS VALUES (2, 'Susi',   NULL,  -900, -1000, 2000);
INSERT INTO GRIESMAYER_ACCOUNTS VALUES (3, 'Fritz',  NULL,  1500, -1000, 2000);
INSERT INTO GRIESMAYER_ACCOUNTS VALUES (4, 'Andrea', NULL,  1000, -1000, 2000);
INSERT INTO GRIESMAYER_ACCOUNTS VALUES (5, 'Marion', NULL,   800, -1000, 2000);
INSERT INTO GRIESMAYER_ACCOUNTS VALUES (6, 'Verena', NULL, -1000, -1000, 2000);

DROP TABLE GRIESMAYER_TRANSFERS;

CREATE TABLE GRIESMAYER_TRANSFERS
(
  TRANSFER_ID         INTEGER      NOT NULL PRIMARY KEY,
  ACCOUNT_ID_FROM     INTEGER      NOT NULL,
  ACCOUNT_ID_TO       INTEGER      NOT NULL,
  ORDER_DATE          DATE         NOT NULL,
  TRANSACTION_DATE    DATE,
  TRANSACTION_STATUS  CHAR(1)      NOT NULL,
  BALANCE             DECIMAL(8,2) NOT NULL
);

COMMIT;

DELETE FROM   GRIESMAYER_TRANSFERS;

DROP SEQUENCE SEQ_GRIESMAYER_TRANSFER_ID;

CREATE SEQUENCE SEQ_GRIESMAYER_TRANSFER_ID
START WITH 1000
INCREMENT BY 1;

COMMIT;

SELECT SEQ_GRIESMAYER_TRANSFER_ID.nextval
FROM   DUAL;

SELECT *
FROM   GRIESMAYER_ACCOUNTS;

SELECT *
FROM   GRIESMAYER_TRANSFERS;
