CREATE OR REPLACE FUNCTION GRIESMAYER_TRANSFER(
    p_ACCOUNT_ID_FROM IN NUMBER,
    p_ACCOUNT_ID_TO   IN NUMBER,
    p_BALANCE         IN NUMBER)
RETURN NUMBER
IS
    v_TRANSFER_ID   NUMBER;
    v_ACCOUNT_FOUND NUMBER;
BEGIN
    SET TRANSACTION ISOLATION LEVEL READ COMMITTED;
    
    v_TRANSFER_ID := SEQ_GRIESMAYER_TRANSFER_ID.nextval;
    
    SELECT count(*)
    INTO   v_ACCOUNT_FOUND
    FROM   GRIESMAYER_ACCOUNTS
    WHERE  ACCOUNT_ID = p_ACCOUNT_ID_FROM;
    IF (v_ACCOUNT_FOUND <> 1) THEN
        dbms_output.put_line('The ACCOUNT_ID ' || p_ACCOUNT_ID_FROM || ' was not found!');
        ROLLBACK;
        RETURN -20001;
    END IF;

    SELECT count(*)
    INTO   v_ACCOUNT_FOUND
    FROM   GRIESMAYER_ACCOUNTS
    WHERE  ACCOUNT_ID = p_ACCOUNT_ID_TO;
    IF (v_ACCOUNT_FOUND <> 1) THEN
        dbms_output.put_line('The ACCOUNT_ID ' || p_ACCOUNT_ID_TO || ' was not found!');
        ROLLBACK;
        RETURN -20002;
    END IF;

    INSERT INTO GRIESMAYER_TRANSFERS VALUES (v_TRANSFER_ID, p_ACCOUNT_ID_FROM, p_ACCOUNT_ID_TO, sysdate, NULL, 'O', p_BALANCE);

    UPDATE GRIESMAYER_ACCOUNTS
    SET    BALANCE = BALANCE - p_BALANCE,
           LAST_TRANSACTION_ID = v_TRANSFER_ID
    WHERE  ACCOUNT_ID = p_ACCOUNT_ID_FROM;

    UPDATE GRIESMAYER_ACCOUNTS
    SET    BALANCE = BALANCE + p_BALANCE,
           LAST_TRANSACTION_ID = v_TRANSFER_ID
    WHERE  ACCOUNT_ID = p_ACCOUNT_ID_TO;

    UPDATE GRIESMAYER_TRANSFERS
    SET    TRANSACTION_DATE = sysdate,
           TRANSACTION_STATUS = 'D'
    WHERE  TRANSFER_ID = v_TRANSFER_ID;

    COMMIT;    
    RETURN v_TRANSFER_ID;
END;