/*****/
/* 2 */
/*****/

CREATE TABLE GRIESMAYER_ACCOUNTS
(
  ACCOUNT_ID         INTEGER      NOT NULL PRIMARY KEY,
  FIRST_NAME         VARCHAR(15)  NOT NULL,
  LAST_TRANSACTION   DATE         NOT NULL,
  BALANCE            DECIMAL(8,2) NOT NULL,
  CREDIT_LIMIT       DECIMAL(8,2) NOT NULL
);

DELETE FROM   GRIESMAYER_ACCOUNTS;

INSERT INTO GRIESMAYER_ACCOUNTS VALUES (1, 'Alex',   sysdate,                             200, -1000);
INSERT INTO GRIESMAYER_ACCOUNTS VALUES (2, 'Susi',   TO_DATE('2001-08-20', 'yyyy-mm-dd'), 200, -1000);
INSERT INTO GRIESMAYER_ACCOUNTS VALUES (3, 'Max',    sysdate,                             200, -1000);
INSERT INTO GRIESMAYER_ACCOUNTS VALUES (4, 'Andrea', TO_DATE('2020-01-10', 'yyyy-mm-dd'), 200, -1000);
INSERT INTO GRIESMAYER_ACCOUNTS VALUES (5, 'Verena', TO_DATE('2024-07-12', 'yyyy-mm-dd'), 200, -1000);
INSERT INTO GRIESMAYER_ACCOUNTS VALUES (6, 'Marion', TO_DATE('2024-06-17', 'yyyy-mm-dd'), 200, -1000);

COMMIT;

SELECT *
FROM   GRIESMAYER_ACCOUNTS;



/*****/
/* 2 */
/*****/
/* SIMPLE OUTPUT */
CREATE OR REPLACE PROCEDURE GREET_USER IS
BEGIN
	dbms_output.put_line('Hello Thomas!');
END;

SET SERVEROUTPUT ON;
BEGIN
   GREET_USER();
END;



/*****/
/* 3 */
/*****/
/* PARAMETER */
CREATE OR REPLACE PROCEDURE GREET_USER2(USER_NAME IN VARCHAR2) IS
BEGIN
	dbms_output.put_line('Hello ' || USER_NAME || '!');
END;

SET SERVEROUTPUT ON;
BEGIN
   GREET_USER2('Max');
END;



/*****/
/* 4 */
/*****/
/* ADD into */
/* ADD if   */
CREATE OR REPLACE PROCEDURE GREET_CUSTOMER (p_ACCOUNT_ID IN NUMBER) IS
   v_FIRST_NAME            VARCHAR(15);
   v_LAST_TRANSACTION      DATE;
   v_LAST_TRANSACTION_YEAR NUMBER;
   v_ACTUAL_YEAR           NUMBER;
BEGIN
   DBMS_OUTPUT.PUT_LINE('Hallo');

   SELECT FIRST_NAME,
          LAST_TRANSACTION,
          EXTRACT(YEAR FROM LAST_TRANSACTION)
   INTO   v_FIRST_NAME,
          v_LAST_TRANSACTION,
          v_LAST_TRANSACTION_YEAR
   FROM   GRIESMAYER_ACCOUNTS
   WHERE  ACCOUNT_ID = p_ACCOUNT_ID;

   v_ACTUAL_YEAR := EXTRACT(YEAR FROM sysdate);
   --v_ACTUAL_YEAR := 2024;

   -- Output the result
   DBMS_OUTPUT.PUT_LINE(v_FIRST_NAME || ' ' || v_LAST_TRANSACTION || ' - ' || v_LAST_TRANSACTION_YEAR || ' = ' || v_ACTUAL_YEAR);

   IF (v_LAST_TRANSACTION_YEAR = v_ACTUAL_YEAR) THEN
      DBMS_OUTPUT.PUT_LINE('This YEAR!!!');
   END IF;

EXCEPTION
   -- Exception handling if no data is found
   WHEN NO_DATA_FOUND THEN
      DBMS_OUTPUT.PUT_LINE('No account found with ID ' || p_ACCOUNT_ID);
   -- Exception handling for any other errors
   WHEN OTHERS THEN
      DBMS_OUTPUT.PUT_LINE('An unexpected error occurred.');
END GREET_CUSTOMER;



SELECT *
FROM   GRIESMAYER_ACCOUNTS;

SET SERVEROUTPUT ON;
BEGIN
   GREET_CUSTOMER(1);
END;

SET SERVEROUTPUT ON;
BEGIN
   GREET_CUSTOMER(2);
END;

SET SERVEROUTPUT ON;
BEGIN
   GREET_CUSTOMER(3);
END;

SET SERVEROUTPUT ON;
BEGIN
   GREET_CUSTOMER(4);
END;

