/*************************************************/
/**                 SHELL                       **/
/*************************************************/

!!! TERMINAL !!!

ls /opt/oracle/oradata/XE/XEPDB1
cat /opt/oracle/product/21c/dbhomeXE/dbs/init.ora
ls /opt/oracle/product/21c/dbhomeXE/bin/orapwd



/*************************************************/
/**                 ARCHIVE LOG                 **/
/**                 SHELL                       **/
/*************************************************/

!!! TERMINAL !!!

sqlplus sys/oracle AS SYSDBA

SHUTDOWN IMMEDIATE;

STARTUP MOUNT;

ALTER DATABASE ARCHIVELOG;

ALTER DATABASE OPEN;

ARCHIVE LOG LIST;

SELECT LOG_MODE
FROM   SYS.V$DATABASE;



/*************************************************/
/**                 system USER !!!              */
/*************************************************/

!!! DBeaver !!!

DROP TABLESPACE TBS_GRIESMAYER_RECOVER INCLUDING CONTENTS AND DATAFILES;

COMMIT;


CREATE SMALLFILE TABLESPACE TBS_GRIESMAYER_RECOVER
DATAFILE '/opt/oracle/oradata/XE/XEPDB1/griesmayer1.dbf' SIZE 10M AUTOEXTEND ON NEXT 1M MAXSIZE UNLIMITED,
'/opt/oracle/oradata/XE/XEPDB1/griesmayer2.dbf' SIZE 10M
LOGGING EXTENT MANAGEMENT LOCAL SEGMENT SPACE MANAGEMENT AUTO;

COMMIT;

SELECT TABLESPACE_NAME,
       STATUS,
       CONTENTS
FROM   USER_TABLESPACES;

SELECT TABLESPACE_NAME,
       CON_ID
FROM   CDB_TABLESPACES;
!!! >1 !!!

DROP USER GRIESMAYER CASCADE;

!!! TBS_GRIESMAYER_RECOVER !!!
CREATE USER GRIESMAYER PROFILE "DEFAULT" IDENTIFIED BY "oracle"
DEFAULT TABLESPACE TBS_GRIESMAYER_RECOVER
TEMPORARY TABLESPACE TEMP
ACCOUNT UNLOCK;

GRANT SELECT ANY DICTIONARY TO GRIESMAYER;
GRANT UNLIMITED TABLESPACE TO GRIESMAYER;
GRANT CONNECT TO GRIESMAYER;
GRANT RESOURCE TO GRIESMAYER;



/*************************************************/
/**             griesmayer USER !!!              */
/*************************************************/

!!! DBeaver !!!

CREATE TABLE GRIESMAYER_CUSTOMER
(
	CUSTOMER_ID INTEGER PRIMARY KEY,
	FIRST_NAME  VARCHAR2(20),
	BALANCE     DECIMAL(10,2)
);

INSERT INTO GRIESMAYER_CUSTOMER VALUES (1, 'Fritz',  300);
INSERT INTO GRIESMAYER_CUSTOMER VALUES (2, 'Hugo',   500);
INSERT INTO GRIESMAYER_CUSTOMER VALUES (3, 'Alex',   -200);
INSERT INTO GRIESMAYER_CUSTOMER VALUES (4, 'Andrea', 700);
INSERT INTO GRIESMAYER_CUSTOMER VALUES (5, 'Marion', 900);
INSERT INTO GRIESMAYER_CUSTOMER VALUES (6, 'Verena', 100);
INSERT INTO GRIESMAYER_CUSTOMER VALUES (7, 'Thomas',   0);
INSERT INTO GRIESMAYER_CUSTOMER VALUES (8, 'Werner',  50);
INSERT INTO GRIESMAYER_CUSTOMER VALUES (9, 'Max',     20);

COMMIT;



/*************************************************/
/**                 SHELL                       **/
/*************************************************/

!!! TERMINAL !!!

ls /opt/oracle/oradata/XE/XEPDB1
rm /opt/oracle/oradata/XE/XEPDB1/griesmayer*.dbf



/*************************************************/
/**                 RECOVER                      */
/*************************************************/

!!! TERMINAL !!!

sqlplus sys/oracle AS SYSDBA

SHUTDOWN ABORT;
STARTUP;



/*************************************************/
/**             griesmayer USER !!!              */
/*************************************************/

!!! TERMINAL !!!

sqlplus GRIESMAYER/oracle@XEPDB1

SELECT *
FROM   GRIESMAYER_CUSTOMER;



/*************************************************/
/**                 RMAN                        **/
/**                 RECOVER                      */
/*************************************************/
https://www.oracle.com/webfolder/technetwork/de/community/dbadmin/tipps/oracle_data_recovery_advisor/index.html

!!! TERMINAL !!!

rman
connect target;
list failure;
advise failure;
repair failure;
exit;




/*************************************************/
/**                 STARTUP                      */
/*************************************************/

!!! TERMINAL !!!

SHUTDOWN IMMEDIATE;
STARTUP;



/*************************************************/
/**             griesmayer USER !!!              */
/*************************************************/

!!! DBeaver !!!

SELECT *
FROM   GRIESMAYER_CUSTOMER
