/*************************************************/
/**                 oracle USER !!!              */
/*************************************************/

!!! TERMINAL !!!

$ lsnrctl status


/*************************************************/
/**                 system USER !!!              */
/*************************************************/

SELECT PID as ORA_PID,
       SPID as LNX_PID,
       PNAME,
       USERNAME
FROM   V$PROCESS 
WHERE  PNAME IS NOT NULL 
ORDER BY PNAME;

Operating system PID!


/*************************************************/
/**                 system USER !!!              */
/*************************************************/

DROP USER GRIESMAYER CASCADE;

CREATE USER GRIESMAYER PROFILE "DEFAULT" IDENTIFIED BY "oracle"
DEFAULT TABLESPACE USERS
TEMPORARY TABLESPACE TEMP
ACCOUNT UNLOCK;

GRANT SELECT ANY DICTIONARY TO GRIESMAYER;
GRANT UNLIMITED TABLESPACE TO GRIESMAYER;
GRANT CONNECT TO GRIESMAYER;
GRANT RESOURCE TO GRIESMAYER;


/*************************************************/
/**                 griesmayer USER !!!          */
/*************************************************/

!!! TERMINAL !!!

sqlplus GRIESMAYER/oracle@XEPDB1

DROP TABLE GRIESMAYER_CUSTOMER;

CREATE TABLE GRIESMAYER_CUSTOMER
(
	CUSTOMER_ID INTEGER PRIMARY KEY,
	FIRST_NAME  VARCHAR2(20),
	BALANCE     DECIMAL(10,2)
);

COMMIT;

INSERT INTO GRIESMAYER_CUSTOMER VALUES (1, 'Fritz',  300);
INSERT INTO GRIESMAYER_CUSTOMER VALUES (2, 'Hugo',   500);
INSERT INTO GRIESMAYER_CUSTOMER VALUES (3, 'Alex',   -200);
INSERT INTO GRIESMAYER_CUSTOMER VALUES (4, 'Andrea', 700);
INSERT INTO GRIESMAYER_CUSTOMER VALUES (5, 'Marion', 900);
INSERT INTO GRIESMAYER_CUSTOMER VALUES (6, 'Verena', 100);
INSERT INTO GRIESMAYER_CUSTOMER VALUES (7, 'Thomas',   0);
INSERT INTO GRIESMAYER_CUSTOMER VALUES (8, 'Werner',  50);
INSERT INTO GRIESMAYER_CUSTOMER VALUES (9, 'Max',     20);

SELECT *
FROM   GRIESMAYER_CUSTOMER;


/*************************************************/
/**                 system USER !!!              */
/*************************************************/

SELECT SID,
       SERIAL#,
       STATUS,
       USERNAME
FROM   V$SESSION;

ALTER SYSTEM KILL SESSION '153,31';


/*************************************************/
/**                 griesmayer USER !!!          */
/*************************************************/

SELECT *
FROM   GRIESMAYER_CUSTOMER;
