package application;

import java.io.File;

import javafx.application.Platform;
import javafx.scene.control.Alert.AlertType;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.BorderPane;
import javafx.stage.FileChooser;
import model.Auto;
import model.AutoException;
import model.Fahrzeug;
import model.Parkplatz;

public class RootBorderPane extends BorderPane
{
	private MenuBar menuBar;
	private Menu menuDatei;
	private MenuItem menuItemImport, menuItemExport, menuItemBeenden;
	private Menu menuFahrzeug, menuSort;
	private MenuItem menuItemSortBaujahr, menuItemSortKennzeichen, menuItemSortID, menuItemAndern, menuItemAusparken, menuItemEinparken, menuItemAnzahlAutomatik, menuItemAvgBaujahr, menuItemMinBaujahr, menuItemAbkassieren; 
		
	private Parkplatz parkplatz;
	
	private FahrzeugUbersicht fahrzeugUbersicht;
	
	public RootBorderPane()
	{
		initMenu();
		addMenu();
		initComponents();
		addComponents();
		enableComponents(false);
		initHandlers();
	}

	private void initMenu()
	{
		menuBar = new MenuBar();
		
		menuDatei = new Menu("Datei");
		menuItemImport = new MenuItem("Import");
		menuItemExport = new MenuItem("Export");
		menuItemBeenden = new MenuItem("Beenden");
		
		menuFahrzeug = new Menu("Fahrzeug");
		menuSort = new Menu("Sort");
		menuItemSortBaujahr = new MenuItem("Baujahr");
		menuItemSortKennzeichen = new MenuItem("Kennzeichen");
		menuItemSortID = new MenuItem("ID");
		menuItemAndern = new MenuItem("Ändern");
		menuItemAusparken = new MenuItem("Ausparken");
		menuItemEinparken = new MenuItem("Einparken");
		menuItemAnzahlAutomatik = new MenuItem("Anzahl Automatik");
		menuItemAvgBaujahr = new MenuItem("AVG Baujahr Automatik");
		menuItemMinBaujahr = new MenuItem("Min Baujahr");
		menuItemAbkassieren = new MenuItem("Abkassieren");
	}

	private void addMenu()
	{
		menuSort.getItems().addAll(menuItemSortBaujahr, menuItemSortKennzeichen, menuItemSortID);
		menuFahrzeug.getItems().addAll(menuSort, menuItemAndern, menuItemAusparken, menuItemEinparken, menuItemAnzahlAutomatik, menuItemAvgBaujahr, menuItemMinBaujahr, menuItemAbkassieren);

		menuDatei.getItems().addAll(menuItemImport, menuItemExport, menuItemBeenden);
		
		menuBar.getMenus().addAll(menuDatei, menuFahrzeug);
	}

	private void initComponents()
	{
		parkplatz = new Parkplatz();
		fahrzeugUbersicht = new FahrzeugUbersicht();
	}

	private void addComponents()
	{
		setTop(menuBar);
		setCenter(fahrzeugUbersicht);
	}
	
	private void enableComponents(boolean enable)
	{
		menuItemExport.setDisable(!enable);
		menuItemSortBaujahr.setDisable(!enable);
		menuItemSortKennzeichen.setDisable(!enable);
		menuItemSortID.setDisable(!enable);
		menuItemAndern.setDisable(!enable);
		menuItemAusparken.setDisable(!enable);
		menuItemAnzahlAutomatik.setDisable(!enable);
		menuItemAvgBaujahr.setDisable(!enable);
		menuItemMinBaujahr.setDisable(!enable);
		menuItemAbkassieren.setDisable(!enable);
		fahrzeugUbersicht.setVisible(enable);
	}

	private void initHandlers()
	{
		menuItemImport.setOnAction( event -> importAutos() );
		menuItemBeenden.setOnAction( event -> Platform.exit() );
		menuItemMinBaujahr.setOnAction( event -> minBaujahr() );
		menuItemAbkassieren.setOnAction( event -> abkassieren() );
		menuItemAvgBaujahr.setOnAction( event -> avgBaujahr() );
		menuItemSortBaujahr.setOnAction( event -> sortBaujahr() );
		menuItemSortID.setOnAction( event -> sortId() );
		menuItemAusparken.setOnAction( event -> ausparken() );
		menuItemAndern.setOnAction( event -> andern() );
	}
	
	private void andern()
	{
		Fahrzeug welches;
		welches = fahrzeugUbersicht.getSingleAuswahl();
		if (welches != null)
		{
			FahrzeugDialog fahrzeugDialog;
			fahrzeugDialog = new FahrzeugDialog();
			fahrzeugDialog.updateAndShow(welches);
			fahrzeugUbersicht.updateUbersicht(parkplatz.getPlatze());
		}
		else
		{
			Main.showAlert(AlertType.WARNING, "Kein Fahrzeug ausgewählt!");
		}
	}
	
	private void ausparken()
	{
		Fahrzeug welches;
		try
		{
			welches = fahrzeugUbersicht.getSingleAuswahl();
			if (welches != null)
			{
				parkplatz.ausparken(welches);
				fahrzeugUbersicht.updateUbersicht(parkplatz.getPlatze());
			}
			else
			{
				Main.showAlert(AlertType.WARNING, "Fehler: kein Fahrzeug ausgewählt!");
			}
		}
		catch (AutoException e)
		{
			Main.showAlert(AlertType.ERROR, e.getMessage());
		}
	}
	
	private void importAutos()
	{
		FileChooser fileChooser;
		File selected;
		
		try
		{
			fileChooser = new FileChooser();
			
			fileChooser.setInitialDirectory(new File("/home/thomas/Desktop/Code_2017/2akif2/62_EventMenu_Auto/"));
			fileChooser.setTitle("Import von Autos");
			selected = fileChooser.showOpenDialog(null);
			if (selected != null)
			{
				parkplatz.importParkplatz(selected.getAbsolutePath());
				//System.out.println(parkplatz);
				fahrzeugUbersicht.updateUbersicht(parkplatz.getPlatze());
				enableComponents(true);
			}
		}
		catch (AutoException e)
		{
			Main.showAlert(AlertType.ERROR, e.getMessage());
		}
	}
	
	private void minBaujahr()
	{
		int min;
		
		min = parkplatz.minBaujahr();
		Main.showAlert(AlertType.INFORMATION, "Min Baujahr: " + min);
	}
	
	private void abkassieren()
	{
		double sum;
		
		sum = parkplatz.abkassieren();
		Main.showAlert(AlertType.INFORMATION, "Summe abkassiert:" + sum);
	}
	
	private void avgBaujahr()
	{
		double erg;
		try
		{
			erg = parkplatz.avgBaujahrAutomatik();
			Main.showAlert(AlertType.INFORMATION, "AVG Baujahr: " + erg);
		}
		catch (AutoException e)
		{
			Main.showAlert(AlertType.ERROR, e.getMessage());
		}
	}
	
	private void sortBaujahr()
	{
		parkplatz.sortBaujahr();
		System.out.println(parkplatz);
	}
	
	private void sortId()
	{
		parkplatz.sortAutoId();
		System.out.println(parkplatz);
	}
}


















