package application;

import java.time.Year;

import javafx.geometry.Insets;
import javafx.scene.Scene;
import javafx.scene.control.Alert.AlertType;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import model.Auto;
import model.AutoException;
import model.Fahrzeug;
import model.Motorrad;

public class FahrzeugDialog extends Stage
{
	private GridPane gridPaneDialog;
	private Label labelAutoId;
	private TextField textFieldAutoId;
	private Label labelKennzeichen;
	private TextField textFieldKennzeichen;
	private Label labelBaujahr;
	private Slider sliderBaujahr;
	private Label labelBaujahrValue;
	private Label labelAutomatik;
	private CheckBox checkBoxAutomatik;
	private Label labelPS;
	private ComboBox<Integer> comboBoxPS;
	private Button buttonOk;
	private Button buttonAbbruch;
	
	private Fahrzeug fahrzeug;
	
	public FahrzeugDialog()
	{
		initComponents();
		addComponents();
		addHandlers();
	}

	private void initComponents()
	{
		gridPaneDialog = new GridPane();
			gridPaneDialog.setPadding(new Insets(10));
			gridPaneDialog.setHgap(10);
			gridPaneDialog.setVgap(5);
		labelAutoId = new Label("Auto ID:");
		textFieldAutoId = new TextField();
			textFieldAutoId.setEditable(false);
		labelKennzeichen = new Label("Kennzeichen");
		textFieldKennzeichen = new TextField();
		labelBaujahr = new Label("Baujahr");
		sliderBaujahr = new Slider(Year.now().getValue()-30, Year.now().getValue(), Year.now().getValue());
			sliderBaujahr.setMajorTickUnit(10);
			sliderBaujahr.setShowTickLabels(true);
		labelBaujahrValue = new Label();
		labelAutomatik = new Label("Automatik");
		checkBoxAutomatik = new CheckBox();
		labelPS = new Label("PS");
		comboBoxPS = new ComboBox<>();
			comboBoxPS.getItems().addAll(20, 30, 40, 50, 60, 70, 80, 90, 100, 110, 120);
		buttonOk = new Button("OK");
			buttonOk.setPrefWidth(100);
		buttonAbbruch = new Button("Abbruch");
			buttonAbbruch.setPrefWidth(100);
	}

	private void addComponents()
	{
		gridPaneDialog.add(labelAutoId, 0, 0);
		gridPaneDialog.add(textFieldAutoId, 1, 0);
		gridPaneDialog.add(labelKennzeichen, 0, 1);
		gridPaneDialog.add(textFieldKennzeichen, 1, 1);
		gridPaneDialog.add(labelBaujahr, 0, 2);
		gridPaneDialog.add(sliderBaujahr, 1, 2);
		gridPaneDialog.add(labelBaujahrValue, 3, 2);
		gridPaneDialog.add(labelAutomatik, 0, 3);
		gridPaneDialog.add(checkBoxAutomatik, 1, 3);
		gridPaneDialog.add(labelPS, 0, 3);
		gridPaneDialog.add(comboBoxPS, 1, 3);
		gridPaneDialog.add(buttonOk, 0, 4);
		gridPaneDialog.add(buttonAbbruch, 1, 4);
		setScene(new Scene(gridPaneDialog));
	}
	
	private void addHandlers()
	{
		buttonOk.setOnAction( event -> ubernehmen() );
		buttonAbbruch.setOnAction( event -> close() );
		sliderBaujahr.valueProperty().addListener( event -> sliderMoved() );
	}
	
	private void sliderMoved()
	{
		labelBaujahrValue.setText(""+(int)sliderBaujahr.getValue());
	}
	
	private void ubernehmen()
	{
		try
		{
			fahrzeug.setKennzeichen(textFieldKennzeichen.getText());
			fahrzeug.setBaujahr((int)sliderBaujahr.getValue());
			if (fahrzeug instanceof Auto)
			{
				Auto auto = (Auto)fahrzeug;
				auto.setAutomatik(checkBoxAutomatik.isSelected());
			}
			else
			{
				if (fahrzeug instanceof Motorrad)
				{
					((Motorrad)fahrzeug).setPs(comboBoxPS.getValue());
				}
			}
			close();
		}
		catch (AutoException e)
		{
			Main.showAlert(AlertType.ERROR, e.getMessage());
		}
	}

	public void updateAndShow(Fahrzeug welches)
	{
		fahrzeug = welches;
		textFieldAutoId.setText(""+welches.getAutoId());
		textFieldKennzeichen.setText(welches.getKennzeichen());
		sliderBaujahr.setValue(welches.getBaujahr());
		if (welches instanceof Auto)
		{
			Auto auto = (Auto)welches;
			setTitle("Autodaten ändern");
			checkBoxAutomatik.setSelected(auto.getAutomatik());
			labelPS.setVisible(false);
			comboBoxPS.setVisible(false);
			labelAutomatik.setVisible(true);
			checkBoxAutomatik.setVisible(true);
		}
		else
		{
			if (welches instanceof Motorrad)
			{
				setTitle("Motorraddaten ändern");
				comboBoxPS.setValue(((Motorrad)welches).getPs());
				labelPS.setVisible(true);
				comboBoxPS.setVisible(true);
				labelAutomatik.setVisible(false);
				checkBoxAutomatik.setVisible(false);
				
			}
		}
		showAndWait();
	}
}






















