package model;
public class Tagesschuler extends Student
{
    private boolean mannlich;
    
    public Tagesschuler(String name, int alter, boolean mannlich) throws StudentException
    {
    	super(name, alter);
    	setMannlich(mannlich);
    }
    
    public Tagesschuler(String zeile) throws StudentException
    {
    	super(zeile);
    	try
    	{
    		String[] eigenschaften;
    		eigenschaften = zeile.split(";");
    		setMannlich(eigenschaften[3].startsWith("m"));
    	}
    	catch (ArrayIndexOutOfBoundsException e)
    	{
    		throw new StudentException("Ungültige Attributsanzahl!");
    	}
    }
    
    public boolean getMannlich()
    {
        return mannlich;
    }
    
    public String getGeschlecht()
    {
//    	if (mannlich)
//    		return "Mann";
//    	else
//    		return "Frau";
    	return (mannlich ? "Mann" : "Frau");
    }

    public void setMannlich(boolean mannlich)
    {
        this.mannlich = mannlich;
    }

    public void setAlter(int alter) throws StudentException
    {
        if (mannlich == true)
        {
            //13..50
            if ((alter >= 13) && (alter <= 21))
            {
                super.setAlter(alter);
            }
            else
            {
                if (alter<13)
                {
                    //zu jung
                    throw new StudentException("Fehler: Student zu jung!");
                }
                else
                {
                    //zu alt
                	throw new StudentException("Fehler: Student zu alt!");
                }
            }
        }
        else
        {
            //12..55
            if ((alter >= 12) && (alter <= 25))
            {
                super.setAlter(alter);
            }
            else
            {
                if (alter<12)
                {
                    //zu jung
                	throw new StudentException("Fehler: Studentin zu jung!");
                }
                else
                {
                    //zu alt
                	throw new StudentException("Fehler: Studentin zu alt!");
                }
            }
        }
    }

    public String toString()
    {
    	if (mannlich)
    	{
    		return super.toString() + " Mann";
    	}
    	else
    	{
    		return super.toString() + " Frau";
    	}
    }

    public String toStringCSV()
    {
    	return "Tag;" + super.toStringCSV() + (mannlich ? ";m" : ";f");
    }
    
    public double uberweisen()
    {
    	if (mannlich)
    	{
    		return 77;
    	}
    	else
    	{
    		return 67;
    	}
    }
    
}











