package application;

import java.util.List;

import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import model.Student;

public class StudentUbersicht extends TableView<Student>
{
	private TableColumn<Student, String>   columnStudentType;
	private TableColumn<Student, Integer>  columnStudentId;
	private TableColumn<Student, String>   columnName;
	private TableColumn<Student, Integer>  columnAlter;
	private TableColumn<Student, Integer>  columnGeburtsjahr;
	private TableColumn<Student, String>   columnGeschlecht;
	private TableColumn<Student, String>   columnBeruf;
	
	public StudentUbersicht()
	{
		initComponents();
		addComponents();
		addCellValueFactories();
	}

	private void initComponents()
	{
		columnStudentType = new TableColumn<>("Student\nType");
			columnStudentType.setPrefWidth(100);
		columnStudentId = new TableColumn<>("Student ID");
			columnStudentId.setPrefWidth(100);
		columnName = new TableColumn<>("Name");
			columnName.setPrefWidth(100);
		columnAlter = new TableColumn<>("Alter");
			columnAlter.setPrefWidth(100);
		columnGeburtsjahr = new TableColumn<>("Geburtsjahr");
			columnGeburtsjahr.setPrefWidth(100);
		columnGeschlecht = new TableColumn<>("Geschlecht");
			columnGeschlecht.setPrefWidth(100);
		columnBeruf = new TableColumn<>("Beruf");
			columnBeruf.setPrefWidth(100);
	}

	@SuppressWarnings("unchecked")
	private void addComponents()
	{
		getColumns().addAll(columnStudentType, columnStudentId, columnName, columnAlter, columnGeburtsjahr, columnGeschlecht, columnBeruf);
	}
	
	public void updateStudents(List<Student> students)
	{
		getItems().setAll(students);
	}

	private void addCellValueFactories()
	{
		columnStudentType.setCellValueFactory( value -> new ReadOnlyObjectWrapper<>( value.getValue().getClass().getSimpleName() )); 
		columnStudentId.setCellValueFactory( new PropertyValueFactory<>("studentid") );
		columnName.setCellValueFactory( new PropertyValueFactory<>("name") );
		columnAlter.setCellValueFactory( new PropertyValueFactory<>("alter") );
		columnGeburtsjahr.setCellValueFactory( value -> new ReadOnlyObjectWrapper<>( value.getValue().getGeburtsjahr() ));
		columnGeschlecht.setCellValueFactory( value -> new ReadOnlyObjectWrapper<>( value.getValue().getGeschlecht() ) );
		columnBeruf.setCellValueFactory( new PropertyValueFactory<>("beruf") );


	}
}


















