package application;

import java.io.File;

import javafx.application.Platform;
import javafx.scene.control.Alert.AlertType;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.BorderPane;
import javafx.stage.FileChooser;
import javafx.stage.FileChooser.ExtensionFilter;
import model.School;
import model.StudentException;

public class RootBorderPane extends BorderPane
{
	private MenuBar menuBar;
	
	private Menu menuDatei;
	private MenuItem menuItemImport, menuItemExport, menuItemBeenden;
	
	private Menu menuStudent;
	private MenuItem menuItemAufnehmen, menuItemAbmelden, menuItemEinfugen, menuItemEinheben;

	private Menu menuStatistik;
	private MenuItem menuItemAvgAlter, menuItemAnzTagesschuler, menuItemMaxAlter;
	private Menu menuSortieren;
	private MenuItem menuItemSortName, menuItemSortStudentId, menuItemSortAlter;
	private MenuItem menuItemAltern;
	
	private StudentUbersicht studentUbersicht;
	
	private School school;
	
	public RootBorderPane()
	{
		initMenu();
		addMenu();
		initComponents();
		addComponents();
		enableComponents(false);
		initHandlers();
	}

	private void initMenu()
	{
		menuBar = new MenuBar();
		menuDatei = new Menu("Datei");
		menuItemImport = new MenuItem("Import");
		menuItemExport = new MenuItem("Export");
		menuItemBeenden = new MenuItem("Beenden");
		
		menuStudent = new Menu("Student");
		menuItemAufnehmen = new MenuItem("Aufnehmen");
		menuItemAbmelden = new MenuItem("Abmelden");
		menuItemEinfugen = new MenuItem("Einfügen");
		menuItemEinheben = new MenuItem("Einheben");
		menuStatistik = new Menu("Statistik");
		menuItemAvgAlter = new MenuItem("AVG Alter");
		menuItemAnzTagesschuler = new MenuItem("Anzahl Tagesschüler");
		menuItemMaxAlter = new MenuItem("Max Alter");
		menuSortieren = new Menu("Sortieren");
		menuItemSortName = new MenuItem("nach Name");
		menuItemSortStudentId = new MenuItem("nach StudentID");
		menuItemSortAlter = new MenuItem("nach Alter");
		menuItemAltern = new MenuItem("Ein Jahr älter");
		
	}

	private void addMenu()
	{
		menuDatei.getItems().addAll(menuItemImport, menuItemExport, menuItemBeenden);
		
		menuStatistik.getItems().addAll(menuItemAvgAlter, menuItemAnzTagesschuler, menuItemMaxAlter);
		menuSortieren.getItems().addAll(menuItemSortName, menuItemSortStudentId, menuItemSortAlter);
		menuStudent.getItems().addAll(menuItemAufnehmen, menuItemAbmelden, menuItemEinfugen, menuItemEinheben, menuStatistik, menuSortieren, menuItemAltern);
		
		menuBar.getMenus().addAll(menuDatei, menuStudent);
		setTop(menuBar);
	}
	
	private void enableComponents(boolean enable)
	{
		menuItemExport.setDisable(!enable);
		menuItemAbmelden.setDisable(!enable);
		menuItemEinfugen.setDisable(!enable);
		menuItemEinheben.setDisable(!enable);
		menuItemAvgAlter.setDisable(!enable);
		menuItemAnzTagesschuler.setDisable(!enable);
		menuItemMaxAlter.setDisable(!enable);
		menuItemSortName.setDisable(!enable);
		menuItemSortStudentId.setDisable(!enable);
		menuItemSortAlter.setDisable(!enable);
		menuItemAltern.setDisable(!enable);
		studentUbersicht.setVisible(enable);
	}

	private void initComponents()
	{
		school = new School();
		studentUbersicht = new StudentUbersicht();
	}

	private void addComponents()
	{
		setCenter(studentUbersicht);
	}
	
	private void initHandlers()
	{
		menuItemBeenden.setOnAction( event -> Platform.exit() );
		menuItemImport.setOnAction( event -> importStudent() );
		menuItemExport.setOnAction( event -> exportStudent() );
		menuItemSortName.setOnAction( event -> sortName() );
		menuItemSortAlter.setOnAction( event -> sortAlter() );
		menuItemAltern.setOnAction( event -> altern() );
	}
	
	private void altern()
	{
		try
		{
			school.altern();
			studentUbersicht.updateStudents(school.getStudents());
		}
		catch (StudentException e)
		{
			Main.showAlert(AlertType.ERROR, e.getMessage() );
		}		
	}
	
	private void sortAlter()
	{
		school.sortAlter();
		studentUbersicht.updateStudents(school.getStudents());
	}
	
	private void sortName()
	{
		school.sortName();
		studentUbersicht.updateStudents(school.getStudents());
	}

	private void importStudent()
	{
		try
		{
			FileChooser fileChooser;
			File selected;
			
			fileChooser = new FileChooser();
			fileChooser.setTitle("Öffnen einer Studenten Textdatei");
			fileChooser.setInitialDirectory(new File("/home/thomas/Desktop/Code_2017/2AKIF/12_Textfile_Student"));
			selected = fileChooser.showOpenDialog(null);
			if (selected != null)
			{
				school.importSchool(selected.getAbsolutePath());
				//System.out.println(school);
				studentUbersicht.updateStudents( school.getStudents() );
				enableComponents(true);	
			}
		}
		catch (StudentException e)
		{
			Main.showAlert(AlertType.ERROR, e.getMessage());
		}
		catch (IllegalArgumentException e)
		{
			Main.showAlert(AlertType.ERROR, "Falsches Initial-Verzeichnis für FileChooser");
		}
	}	

	private void exportStudent()
	{
		try
		{
			FileChooser fileChooser;
			File selected;
			
			fileChooser = new FileChooser();
			fileChooser.setTitle("Speichern der Studenten in einer Textdatei");
			fileChooser.setInitialDirectory(new File("/home/thomas/Desktop/Code_2017/2AKIF/12_Textfile_Student"));
			selected = fileChooser.showSaveDialog(null);
			if (selected != null)
			{
				school.exportSchool(selected.getAbsolutePath());
				Main.showAlert(AlertType.INFORMATION, "Daten in der Datei " + selected.getName() + "gespeichert!");
			}
		}
		catch (StudentException e)
		{
			Main.showAlert(AlertType.ERROR, e.getMessage());
		}
		catch (IllegalArgumentException e)
		{
			Main.showAlert(AlertType.ERROR, "Falsches Initial-Verzeichnis für FileChooser");
		}
	}	
}






















