package application;

import java.util.List;

import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import model.Fahrzeug;

public class FahrzeugUbersicht extends TableView<Fahrzeug>
{
	private TableColumn<Fahrzeug, String>  columnType;
	private TableColumn<Fahrzeug, Integer> columnAutoId;
	private TableColumn<Fahrzeug, String>  columnKennzeichen;
	private TableColumn<Fahrzeug, Integer> columnBaujahr;
	private TableColumn<Fahrzeug, Integer> columnAlter;
	private TableColumn<Fahrzeug, Integer> columnPs;
	private TableColumn<Fahrzeug, String>  columnAutomatik;
	
	public FahrzeugUbersicht()
	{
		initComponents();
		addComponents();
		addCellValueFactories();
	}

	private void initComponents()
	{
		columnType = new TableColumn<>("Fahrzeug");
			columnType.setPrefWidth(100);
		columnAutoId = new TableColumn<>("Auto ID");
			columnAutoId.setPrefWidth(100);
		columnKennzeichen = new TableColumn<>("Kennzeichen");
			columnKennzeichen.setPrefWidth(100);
		columnBaujahr = new TableColumn<>("Baujahr");
			columnBaujahr.setPrefWidth(100);
		columnAlter = new TableColumn<>("Alter");
			columnAlter.setPrefWidth(100);
		columnPs = new TableColumn<>("PS");
			columnPs.setPrefWidth(100);
		columnAutomatik = new TableColumn<>("Automatik");
			columnAutomatik.setPrefWidth(100);
	}

	@SuppressWarnings("unchecked")
	private void addComponents()
	{
		getColumns().addAll(columnType, columnAutoId, columnKennzeichen, columnBaujahr, columnAlter, columnPs, columnAutomatik);
	}
	
	private void addCellValueFactories()
	{
		columnType.setCellValueFactory( value -> new ReadOnlyObjectWrapper<>( value.getValue().getClass().getSimpleName() ));
		columnAutoId.setCellValueFactory(  new PropertyValueFactory<>("autoId") );
		columnKennzeichen.setCellValueFactory( new PropertyValueFactory<>("kennzeichen") );
		columnBaujahr.setCellValueFactory( new PropertyValueFactory<>("baujahr") );
		columnAlter.setCellValueFactory( value -> new ReadOnlyObjectWrapper<>(value.getValue().getAlter()) );
		columnPs.setCellValueFactory( new PropertyValueFactory<>("ps") );
		columnAutomatik.setCellValueFactory( new PropertyValueFactory<>("automatik") );
	}
	
	public void updateUbersicht(List<Fahrzeug> fahrzeuge)
	{
		getItems().setAll(fahrzeuge);
	}
}




























