package model;
import java.util.Comparator;

public abstract class Student implements Comparable<Student>
{
	private static int lastid=1000;
	private int studentid;
    private int alter;
    private String name;
    private School school;
    
	public Student(String name, int alter) throws StudentException
    {
    	setStudentid();
        setName(name);
        setAlter(alter);
    }
    
    public Student(String zeile) throws StudentException
    {
    	String[] eigenschaften;
    	
    	try
    	{
    		eigenschaften = zeile.split(";");
    		setStudentid();
    		setName(eigenschaften[2]);
    		setAlter(Integer.parseInt(eigenschaften[1]));
    	}
    	catch (ArrayIndexOutOfBoundsException e)
    	{
    		throw new StudentException("Ungültige Anzahl an Attributen!");
    	}
    	catch (NumberFormatException e)
    	{
    		throw new StudentException("Ungültiges Alter!");
    	}
    }
    
    public Student(int alter) throws StudentException
    {
    	setStudentid();
        setName("Unkn");
        setAlter(alter);
    }
    
    public Student() throws StudentException
    {
    	setStudentid();
        setName("Unkn");
        setAlter(13);
    }
    
    public int getAlter()
    {
        return alter;
    }

    
    public int getStudentid()
	{
		return studentid;
	}

    public static int getLastid()
    {
    	return Student.lastid;
    }
    
    public String getName()
    {
        return name;
    }
    
    public School getSchool()
    {
        return school;
    }

    public void setName(String name) throws StudentException
    {
        if ((name != null) && (name.length()>0))
        {
            this.name = name;
        }
        else
        {
            throw new StudentException("Fehler: kein Name!");
        }
    }
    
    public void setAlter(int alter) throws StudentException
    {
    	if ((alter >= 12) && (alter <= 55))
    	{
    		this.alter = alter;
    	}
    	else
    	{
    		throw new StudentException("Fehler: ungültiges Alter!");
    	}
    }
    
    public void setSchool(School school)
    {
        this.school = school;
    }

	private void setStudentid()
	{
		Student.lastid++;
		this.studentid = Student.lastid;
	}

    public String toString()
    {
    	return studentid + "   " + name + " (" + alter + " Jahre)";
    }

    public String toStringCSV()
    {
    	return alter + ";" + name;
    }
    
    public String getInitialen()
    {
        if (name.contains(" ") == true)
        {
            return "" + name.charAt(0) + name.charAt(name.indexOf(' ')+1);
        }
        else
        {
            return "" + name.charAt(0);
        }
    }
    
    public String getAccount() throws StudentException
    {
        //01234567890123456789
        //Thomas Griesmayer
        String account;
        
        try
        {
        	account = name.substring(0,2);
        	account = account + name.substring(name.indexOf(' '), name.indexOf(' ')+6) + alter;
        	return account.toUpperCase();
        }
        catch (IndexOutOfBoundsException e)
        {
        	throw new StudentException("Fehler: ungültiger Name!");
        }
    }
    
    public void abmelden() throws StudentException
    {
        if (school != null)
        {
            school.abmelden(this);
        }
        else
        {
            throw new StudentException("Fehler: in keiner Schule angemeldet!");
        }
    }
    
    public int compareTo(Student other)
    {
    	//this.name < == > other.getName()
    	//return this.name.compareTo(other.getName());
    	// this.alter < == > other.getAlter()
    	return this.alter - other.getAlter();
    }
    
    public abstract double uberweisen();
    
    /*
    public void testen()
    {
        System.out.println(name.length());
        System.out.println(name.charAt(0));
        System.out.println(name.indexOf(' '));
        System.out.println(name.charAt(name.indexOf(' ')+1));
    }
    */
    
    public static class StudentIDComparator implements Comparator<Student>
    {

		@Override
		public int compare(Student student0, Student student1)
		{
			/*if (student0.getStudentid() == student1.getStudentid())
			{
				return 0;
			}
			else
			{
				if (student0.getStudentid() < student1.getStudentid())
				{
					return -1;
				}
				else
				{
					return 1;
				}
			}*/
			return student0.getStudentid()-student1.getStudentid();
		}
    }
    
    public static class NameComparator implements Comparator<Student>
    {
		@Override
		public int compare(Student student0, Student student1)
		{
			//student0.getName() < == >> student1.getName()
			return student0.getName().compareTo(student1.getName());
		}
    	
    }
}



















