package model;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class School
{
    private ArrayList<Student> students;

    public School()
    {
        students = new ArrayList<>(5);
    }
    
    public void exportSchool(String fileName) throws StudentException
    {
    	try
    	{
    		FileWriter fw = new FileWriter(fileName);
    		BufferedWriter bw = new BufferedWriter(fw);
    		bw.write(toStringCSV());
    		bw.close();
    		fw.close();
    	}
		catch (FileNotFoundException e)
		{
			throw new StudentException("Fehler: Datei nicht gefunden!");
		}
		catch (IOException e)
		{
			throw new StudentException("Fehler: Datei konnte nicht geschrieben werden!");
		}
    	
    }
    
    public void importSchool(String fileName) throws StudentException
    {
		try
		{
			String zeile;
	    	FileReader fr = new FileReader(fileName);
	    	BufferedReader br = new BufferedReader(fr);
	    	zeile = br.readLine();
	    	while (zeile != null)
	    	{
	    		if (zeile.startsWith("Tag"))
	    		{
	    			aufnehmen(new Tagesschuler(zeile));
	    		}
	    		else
	    		{
	    			if (zeile.startsWith("Abend"))
	    			{
	    				aufnehmen(new Abendschuler(zeile));
	    			}
	    			else
	    			{
	    				throw new StudentException("Fehler: ungültiges Objekt in der Datei!");
	    			}
	    		}
	    		zeile = br.readLine();
	    	}
	    	br.close();
	    	fr.close();
		}
		catch (FileNotFoundException e)
		{
			throw new StudentException("Fehler: Datei nicht gefunden!");
		}
		catch (IOException e)
		{
			throw new StudentException("Fehler: Datei konnte nicht gelesen werden!");
		}
    	
    }

    public void aufnehmen(Student wen) throws StudentException
    {
        if (wen != null)
        {
            if (wen.getSchool() == null)
            {
                students.add(wen);
                wen.setSchool(this);
            }
            else
            {
                throw new StudentException("Fehler: Student bereits in einer Schule angemeldet!");
            }
        }
        else
        {
        	throw new StudentException("Fehler: kein Student!");            
        }
    }

    public void abmelden(Student wer) throws StudentException
    {
        if (wer != null)
        {
            if (students.remove(wer) == true)
            {
                wer.setSchool(null);
            }
            else
            {
            	throw new StudentException("Fehler: Student nicht in dieser Schule!");
            }
        }
    }

    public String toString()
    {
        String erg;

        erg = "";
        for (Student s : students)
        {
            erg = erg + s.toString() + "\n";
        }

        return erg;
    }

    public String toStringCSV()
    {
        String erg;

        erg = "";
        for (Student s : students)
        {
            erg = erg + s.toStringCSV() + "\n";
        }

        return erg;
    }
    
    public double avgAlter() throws StudentException
    {
        int summe;

        summe = 0;
        for (Student s: students)
        {
            summe += s.getAlter();
        }
        if (students.size() > 0)
        {
            return (double)summe/students.size();
        }
        else
        {
        	throw new StudentException("Fehler: keine Studenten in der Schule!");
        }
    }

    public int anzahlTagesschulerinnen()
    {
        int anz;
        Tagesschuler t;

        anz = 0;
        for (Student s: students)
        {
        	if (s instanceof Tagesschuler)
        	{
        		t = (Tagesschuler)s;
        		if (t.getMannlich() == false)
        		{
        			anz++;
        		}
        	}
        }
        return anz;
    }

    public int maxAlter()
    {
        int max;

        max = -999;
        for (Student s: students)
        {
            if (s.getAlter() > max)
            {
                max = s.getAlter();
            }
        }
        return max;
    }

    public int losche(String name) throws StudentException
    {
        Iterator<Student> it;
        Student s;
        int anz;

        if (name != null)
        {
            anz = 0;
            it = students.iterator();
            while (it.hasNext())
            {
                s = it.next();
                if (s.getName().equals(name))
                {
                    it.remove();
                    s.setSchool(null);
                    anz++;
                }
            }
            return anz;
        }
        else
        {
        	throw new StudentException("Fehler: ungültiger Name!");
        }
    }

    public void einfugen(Student wen, int pos) throws StudentException
    {
        /* Fehlt Prüfung des Index!!! */
        if (wen != null)
        {
            if (wen.getSchool() == null)
            {
                students.add(pos, wen);
                wen.setSchool(this);
            }
            else
            {
            	throw new StudentException("Fehler: schon in einer anderen Schule!");
            }
        }
        else
        {
        	throw new StudentException("Fehler: kein Student!");
        }
    }

    public double einheben()
    {
    	double summe;
    	
    	summe = 0;
    	for (Student s: students)
    	{
    		summe += s.uberweisen();
    	}
    	return summe;
    }
    
    public void sortName()
    {
    	Collections.sort(students, new Student.NameComparator());
    }
    
    public void sortStudentId()
    {
    	Collections.sort(students, new Student.StudentIDComparator());
    }
    
    public void sortAlter()
    {
    	Collections.sort(students);
    }
    
}





