package application;

import javafx.application.Platform;
import javafx.scene.control.Alert.AlertType;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.BorderPane;
import model.School;
import model.StudentException;

public class RootBorderPane extends BorderPane
{
	private MenuBar menuBar;
	
	private Menu menuDatei;
	private MenuItem menuItemImport, menuItemExport, menuItemBeenden;
	
	private Menu menuStudent;
	private MenuItem menuItemAufnehmen, menuItemAbmelden, menuItemEinfugen, menuItemEinheben;

	private Menu menuStatistik;
	private MenuItem menuItemAvgAlter, menuItemAnzTagesschuler, menuItemMaxAlter;
	private Menu menuSortieren;
	private MenuItem menuItemSortName, menuItemSortStudentId, menuItemSortAlter;
	
	private School school;
	
	public RootBorderPane()
	{
		initMenu();
		addMenu();
		initComponents();
		addComponents();
		enableComponents(false);
		initHandlers();
	}

	private void initMenu()
	{
		menuBar = new MenuBar();
		menuDatei = new Menu("Datei");
		menuItemImport = new MenuItem("Import");
		menuItemExport = new MenuItem("Export");
		menuItemBeenden = new MenuItem("Beenden");
		
		menuStudent = new Menu("Student");
		menuItemAufnehmen = new MenuItem("Aufnehmen");
		menuItemAbmelden = new MenuItem("Abmelden");
		menuItemEinfugen = new MenuItem("Einfügen");
		menuItemEinheben = new MenuItem("Einheben");
		menuStatistik = new Menu("Statistik");
		menuItemAvgAlter = new MenuItem("AVG Alter");
		menuItemAnzTagesschuler = new MenuItem("Anzahl Tagesschüler");
		menuItemMaxAlter = new MenuItem("Max Alter");
		menuSortieren = new Menu("Sortieren");
		menuItemSortName = new MenuItem("nach Name");
		menuItemSortStudentId = new MenuItem("nach StudentID");
		menuItemSortAlter = new MenuItem("nach Alter");
		
	}

	private void addMenu()
	{
		menuDatei.getItems().addAll(menuItemImport, menuItemExport, menuItemBeenden);
		
		menuStatistik.getItems().addAll(menuItemAvgAlter, menuItemAnzTagesschuler, menuItemMaxAlter);
		menuSortieren.getItems().addAll(menuItemSortName, menuItemSortStudentId, menuItemSortAlter);
		menuStudent.getItems().addAll(menuItemAufnehmen, menuItemAbmelden, menuItemEinfugen, menuItemEinheben, menuStatistik, menuSortieren);
		
		menuBar.getMenus().addAll(menuDatei, menuStudent);
		setTop(menuBar);
	}
	
	private void enableComponents(boolean enable)
	{
		menuItemExport.setDisable(!enable);
		menuItemAbmelden.setDisable(!enable);
		menuItemEinfugen.setDisable(!enable);
		menuItemEinheben.setDisable(!enable);
		menuItemAvgAlter.setDisable(!enable);
		menuItemAnzTagesschuler.setDisable(!enable);
		menuItemMaxAlter.setDisable(!enable);
		menuItemSortName.setDisable(!enable);
		menuItemSortStudentId.setDisable(!enable);
		menuItemSortAlter.setDisable(!enable);
	}

	private void initComponents()
	{
		school = new School();
	}

	private void addComponents()
	{
	}
	
	private void initHandlers()
	{
		menuItemBeenden.setOnAction( event -> Platform.exit() );
		menuItemImport.setOnAction( event -> importStudent() );
	}

	private void importStudent()
	{
		try
		{
			school.importSchool("/home/thomas/Desktop/Code_2017/2AKIF/12_Textfile_Student/students.txt");
			System.out.println(school);
			enableComponents(true);
		}
		catch (StudentException e)
		{
			Main.showAlert(AlertType.ERROR, e.getMessage());
		}
	}	
}






















