package application;

import java.io.File;

import javafx.application.Platform;
import javafx.scene.control.Alert.AlertType;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.BorderPane;
import javafx.stage.FileChooser;
import model.AutoException;
import model.Parkplatz;

public class RootBorderPane extends BorderPane
{
	private MenuBar menuBar;
	private Menu menuDatei;
	private MenuItem menuItemImport, menuItemExport, menuItemBeenden;
	private Menu menuFahrzeug, menuSort;
	private MenuItem menuItemSortBaujahr, menuItemSortKennzeichen, menuItemSortID, menuItemAusparken, menuItemEinparken, menuItemAnzahlAutomatik, menuItemAvgBaujahr, menuItemMinBaujahr, menuItemAbkassieren; 
		
	private Parkplatz parkplatz;
	
	public RootBorderPane()
	{
		initMenu();
		addMenu();
		initComponents();
		addComponents();
		enableComponents(false);
		initHandlers();
	}

	private void initMenu()
	{
		menuBar = new MenuBar();
		
		menuDatei = new Menu("Datei");
		menuItemImport = new MenuItem("Import");
		menuItemExport = new MenuItem("Export");
		menuItemBeenden = new MenuItem("Beenden");
		
		menuFahrzeug = new Menu("Fahrzeug");
		menuSort = new Menu("Sort");
		menuItemSortBaujahr = new MenuItem("Baujahr");
		menuItemSortKennzeichen = new MenuItem("Kennzeichen");
		menuItemSortID = new MenuItem("ID");
		menuItemAusparken = new MenuItem("Ausparken");
		menuItemEinparken = new MenuItem("Einparken");
		menuItemAnzahlAutomatik = new MenuItem("Anzahl Automatik");
		menuItemAvgBaujahr = new MenuItem("AVG Baujahr Automatik");
		menuItemMinBaujahr = new MenuItem("Min Baujahr");
		menuItemAbkassieren = new MenuItem("Abkassieren");
	}

	private void addMenu()
	{
		menuSort.getItems().addAll(menuItemSortBaujahr, menuItemSortKennzeichen, menuItemSortID);
		menuFahrzeug.getItems().addAll(menuSort, menuItemAusparken, menuItemEinparken, menuItemAnzahlAutomatik, menuItemAvgBaujahr, menuItemMinBaujahr, menuItemAbkassieren);

		menuDatei.getItems().addAll(menuItemImport, menuItemExport, menuItemBeenden);
		
		menuBar.getMenus().addAll(menuDatei, menuFahrzeug);
	}

	private void initComponents()
	{
		parkplatz = new Parkplatz();
	}

	private void addComponents()
	{
		setTop(menuBar);
	}
	
	private void enableComponents(boolean enable)
	{
		menuItemExport.setDisable(!enable);
		menuItemSortBaujahr.setDisable(!enable);
		menuItemSortKennzeichen.setDisable(!enable);
		menuItemSortID.setDisable(!enable);
		menuItemAusparken.setDisable(!enable);
		menuItemAnzahlAutomatik.setDisable(!enable);
		menuItemAvgBaujahr.setDisable(!enable);
		menuItemMinBaujahr.setDisable(!enable);
		menuItemAbkassieren.setDisable(!enable);
	}

	private void initHandlers()
	{
		menuItemImport.setOnAction( event -> importAutos() );
		menuItemBeenden.setOnAction( event -> Platform.exit() );
	}
	
	private void importAutos()
	{
		try
		{
			parkplatz.importParkplatz("/home/thomas/Desktop/Code_2017/2akif2/62_EventMenu_Auto/Autos.txt");
			System.out.println(parkplatz);
			enableComponents(true);
		}
		catch (AutoException e)
		{
			Main.showAlert(AlertType.ERROR, e.getMessage());
		}
	}
}


















