package application;

import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.BorderPane;

public class RootBorderPane extends BorderPane
{
	private MenuBar menuBar;
	
	private Menu menuDatei;
	private MenuItem menuItemImport, menuItemExport, menuItemBeenden;
	
	private Menu menuStudent;
	private MenuItem menuItemAufnehmen, menuItemAbmelden, menuItemEinfugen, menuItemEinheben;

	private Menu menuStatistik;
	private MenuItem menuItemAvgAlter, menuItemAnzTagesschuler, menuItemMaxAlter;
	private Menu menuSortieren;
	private MenuItem menuItemSortName, menuItemSortStudentId, menuItemSortAlter;
	
	public RootBorderPane()
	{
		initMenu();
		addMenu();
		initComponents();
		addComponents();
	}

	private void initMenu()
	{
		menuBar = new MenuBar();
		menuDatei = new Menu("Datei");
		menuItemImport = new MenuItem("Import");
		menuItemExport = new MenuItem("Export");
		menuItemBeenden = new MenuItem("Beenden");
		
		menuStudent = new Menu("Student");
		menuItemAufnehmen = new MenuItem("Aufnehmen");
		menuItemAbmelden = new MenuItem("Abmelden");
		menuItemEinfugen = new MenuItem("Einfügen");
		menuItemEinheben = new MenuItem("Einheben");
		menuStatistik = new Menu("Statistik");
		menuItemAvgAlter = new MenuItem("AVG Alter");
		menuItemAnzTagesschuler = new MenuItem("Anzahl Tagesschüler");
		menuItemMaxAlter = new MenuItem("Max Alter");
		menuSortieren = new Menu("Sortieren");
		menuItemSortName = new MenuItem("nach Name");
		menuItemSortStudentId = new MenuItem("nach StudentID");
		menuItemSortAlter = new MenuItem("nach Alter");
		
	}

	private void addMenu()
	{
		menuDatei.getItems().addAll(menuItemImport, menuItemExport, menuItemBeenden);
		
		menuStatistik.getItems().addAll(menuItemAvgAlter, menuItemAnzTagesschuler, menuItemMaxAlter);
		menuSortieren.getItems().addAll(menuItemSortName, menuItemSortStudentId, menuItemSortAlter);
		menuStudent.getItems().addAll(menuItemAufnehmen, menuItemAbmelden, menuItemEinfugen, menuItemEinheben, menuStatistik, menuSortieren);
		
		menuBar.getMenus().addAll(menuDatei, menuStudent);
		setTop(menuBar);
	}

	private void initComponents()
	{
	}

	private void addComponents()
	{
	}
}
