package application;

import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.BorderPane;

public class RootBorderPane extends BorderPane
{
	private MenuBar menuBar;
	private Menu menuDatei;
	private MenuItem menuItemImport, menuItemExport, menuItemBeenden;
	private Menu menuFahrzeug, menuSort;
	private MenuItem menuItemSortBaujahr, menuItemSortKennzeichen, menuItemSortID, menuItemAusparken, menuItemEinparken, menuItemAnzahlAutomatik, menuItemAvgBaujahr, menuItemMinBaujahr, menuItemAbkassieren; 
	
	public RootBorderPane()
	{
		initMenu();
		addMenu();
		initComponents();
		addComponents();
	}

	private void initMenu()
	{
		menuBar = new MenuBar();
		
		menuDatei = new Menu("Datei");
		menuItemImport = new MenuItem("Import");
		menuItemExport = new MenuItem("Export");
		menuItemBeenden = new MenuItem("Beenden");
		
		menuFahrzeug = new Menu("Fahrzeug");
		menuSort = new Menu("Sort");
		menuItemSortBaujahr = new MenuItem("Baujahr");
		menuItemSortKennzeichen = new MenuItem("Kennzeichen");
		menuItemSortID = new MenuItem("ID");
		menuItemAusparken = new MenuItem("Ausparken");
		menuItemEinparken = new MenuItem("Einparken");
		menuItemAnzahlAutomatik = new MenuItem("Anzahl Automatik");
		menuItemAvgBaujahr = new MenuItem("AVG Baujahr");
		menuItemMinBaujahr = new MenuItem("Min Baujahr");
		menuItemAbkassieren = new MenuItem("Abkassieren");
	}

	private void addMenu()
	{
		menuSort.getItems().addAll(menuItemSortBaujahr, menuItemSortKennzeichen, menuItemSortID);
		menuFahrzeug.getItems().addAll(menuSort, menuItemAusparken, menuItemEinparken, menuItemAnzahlAutomatik, menuItemAvgBaujahr, menuItemMinBaujahr, menuItemAbkassieren);

		menuDatei.getItems().addAll(menuItemImport, menuItemExport, menuItemBeenden);
		
		menuBar.getMenus().addAll(menuDatei, menuFahrzeug);
	}

	private void initComponents()
	{
	}

	private void addComponents()
	{
		setTop(menuBar);
	}
}
