package application;

import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.control.Alert.AlertType;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;

public class RootGridPane extends GridPane
{
	private BorderPane borderPaneLeft;
	private FlowPane flowPaneNorth, flowPaneSouth;
	private Button button1, button2, buttonNorth, buttonSouth;
	private Label labelCenter;
	
	private GridPane gridPaneRight;
	private CheckBox checkBox;
	private RadioButton radioButton1, radioButton2, radioButton3;
	private Button buttonOk, buttonAbbruch;
	private Label labelCheckBox, labelRadioButton1, labelRadioButton2, labelRadioButton3;
	
	public RootGridPane()
	{
		initComponents();
		addComponents();
		addEventHandlers();
	}

	private void initComponents()
	{
		borderPaneLeft = new BorderPane();
			borderPaneLeft.setPrefWidth(300);
		button1 = new Button("Button 1");
			button1.setPrefHeight(50);
			button1.setPadding(new Insets(10, 10, 10, 10));
		button2 = new Button("Button 2");
			button2.setPrefHeight(50);
			button2.setPadding(new Insets(10, 10, 10, 10));
		flowPaneNorth = new FlowPane();
			flowPaneNorth.setAlignment(Pos.CENTER);
			flowPaneNorth.setPadding(new Insets(10, 0, 10, 0));
		buttonNorth = new Button("Button North");
			buttonNorth.setPrefHeight(50);
			buttonNorth.setPadding(new Insets(10, 10, 10, 10));
		flowPaneSouth = new FlowPane();
			flowPaneSouth.setAlignment(Pos.CENTER);
			flowPaneSouth.setPadding(new Insets(10, 0, 0, 0));
		buttonSouth = new Button("Button South");
			buttonSouth.setPrefHeight(50);
			buttonSouth.setPadding(new Insets(10, 10, 10, 10));
		labelCenter = new Label("Center");
			labelCenter.setPadding(new Insets(10, 10, 10, 10));
			
		gridPaneRight = new GridPane();
			gridPaneRight.setPadding(new Insets(10, 10, 10, 30));
			gridPaneRight.setVgap(10);
			gridPaneRight.setHgap(10);
		labelCheckBox = new Label("CheckBox");
		checkBox = new CheckBox("CBX");
		labelRadioButton1 = new Label("RadioButton1");
		radioButton1 = new RadioButton();
		labelRadioButton2 = new Label("RadioButton2");
		radioButton2 = new RadioButton();
		labelRadioButton3 = new Label("RadioButton3");
		radioButton3 = new RadioButton("RBT3");
		buttonOk = new Button("OK");
		buttonAbbruch = new Button("Abbruch");
	}

	private void addComponents()
	{
		ToggleGroup toggleGroup = new ToggleGroup();
		flowPaneNorth.getChildren().add(buttonNorth);
		flowPaneSouth.getChildren().add(buttonSouth);
		borderPaneLeft.setLeft(button1);
		borderPaneLeft.setRight(button2);
		borderPaneLeft.setTop(flowPaneNorth);
		borderPaneLeft.setBottom(flowPaneSouth);
		borderPaneLeft.setCenter(labelCenter);
		
		toggleGroup.getToggles().addAll(radioButton1, radioButton2, radioButton3);
		gridPaneRight.add(labelCheckBox, 0, 0);
		gridPaneRight.add(checkBox, 1, 0);
		gridPaneRight.add(labelRadioButton1, 0, 1);
		gridPaneRight.add(radioButton1, 1, 1);
		gridPaneRight.add(labelRadioButton2, 0, 2);
		gridPaneRight.add(radioButton2, 1, 2);
		gridPaneRight.add(labelRadioButton3, 0, 3);
		gridPaneRight.add(radioButton3, 1, 3);
		gridPaneRight.add(buttonOk, 0, 4);
		gridPaneRight.add(buttonAbbruch, 1, 4);
		
		add(borderPaneLeft, 0, 0);
		add(gridPaneRight, 1, 0);
	}
	
	private void addEventHandlers()
	{
		button1.setOnAction( event -> Main.showAlert(AlertType.ERROR, "Pass doch auf!!!") );
		buttonSouth.setOnAction( event -> Main.showAlert(AlertType.INFORMATION, "Bin ganz im Süden!") );
		buttonAbbruch.setOnAction( event -> Platform.exit() );
		buttonOk.setOnAction( event -> printButtons() );
	}
	
	private void printButtons()
	{
		String message;
		
		if (checkBox.isSelected())
			message = "CheckBox is selected!\n";
		else
			message = "CheckBox is not selected!\n";
		if (radioButton1.isSelected())
			message += "RadioButton 1 selected!";
		else
			if (radioButton2.isSelected())
				message += "RadioButton 2 selected!";
			else
				if (radioButton3.isSelected())
					message += "RadioButton 3 selected!";
				else
					message += "no RadioButton selected!";
		Main.showAlert(AlertType.INFORMATION, message);
	}
}



















