package application;

import javafx.application.Platform;
import javafx.geometry.Pos;
import javafx.scene.control.Alert.AlertType;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.FlowPane;

public class RootFlowPane extends FlowPane
{
	private CheckBox checkBoxWahl;
	private RadioButton radioButton1, radioButton2, radioButton3;
	private Button buttonOk, buttonBeenden;
	
	public RootFlowPane()
	{
		initComponents();
		addComponents();
		addEventHandlers();
	}

	private void initComponents()
	{
		setHgap(10);
		setAlignment(Pos.CENTER);
		checkBoxWahl = new CheckBox("Wähl mich!");
		radioButton1 = new RadioButton("RB1");
		radioButton2 = new RadioButton("RB2");
		radioButton3 = new RadioButton("RB3");
		buttonOk = new Button("OK");
			buttonOk.setPrefWidth(100);
		buttonBeenden = new Button("Beenden");
			buttonBeenden.setPrefWidth(100);
	}

	private void addComponents()
	{
		ToggleGroup toggleGroup = new ToggleGroup();
		toggleGroup.getToggles().addAll(radioButton1, radioButton2, radioButton3);
		getChildren().addAll(checkBoxWahl, radioButton1, radioButton2, radioButton3, buttonOk, buttonBeenden);
	}
	
	private void addEventHandlers()
	{
		buttonBeenden.setOnAction( event -> Platform.exit() );
		buttonOk.setOnAction( event -> printButtons() );
		setOnMouseClicked( event -> Main.showAlert(AlertType.WARNING, "iiiii - da hat eine Maus ins Fenster geklickt!") );
	}

	private void printButtons()
	{
		String message;
		
		message = "Auswertung der Buttons:\n";
		message += (checkBoxWahl.isSelected() ? "CheckBox is selected\n" : "CheckBox is not selected\n");
		message += (radioButton1.isSelected() ? "RadioButton: 1" : (radioButton2.isSelected() ? "RadioButton: 2" : (radioButton3.isSelected() ? "RadioButton: 3" : "RadioButton: NO" )));	
		Main.showAlert(AlertType.INFORMATION, message);
	}
	
	private void printButtonsOld()
	{
		String message;
		
		message = "Auswertung der Buttons:\n";
		if (checkBoxWahl.isSelected())
			message += "CheckBox is selected\n";
		else
			message += "CheckBox is not selected\n";
		if (radioButton1.isSelected())
			message += "RadioButton: 1";
		else
			if (radioButton2.isSelected())
				message += "RadioButton: 2";
			else
				if (radioButton3.isSelected())
					message += "RadioButton: 3";
				else
					message += "RadioButton: NO";
		Main.showAlert(AlertType.INFORMATION, message);
	}
}














