package application;

import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;

public class RootBorderPane extends BorderPane
{
	private FlowPane topPane;
	private Label labelRadioButton;
	private RadioButton radioButton1, radioButton2, radioButton3;
	
	private GridPane centerPane;
	private Label label1, label2, label3, label4;
	private Button button1, button2, button3, button4;
	
	private FlowPane bottomPane;
	private Button buttonOk, buttonAbbruch;
	
	public RootBorderPane()
	{
		initComponents();
		addComponents();
	}

	private void initComponents()
	{
		topPane = new FlowPane();
			topPane.setHgap(5);
			topPane.setPadding(new Insets(10));
			topPane.setAlignment(Pos.CENTER);
		labelRadioButton = new Label("Das sind RadioButtons in einer ToggleGroup:");
		radioButton1 = new RadioButton();
			radioButton1.setSelected(true);
		radioButton2 = new RadioButton();
		radioButton3 = new RadioButton();
		
		centerPane = new GridPane();
			centerPane.setVgap(10);
			centerPane.setHgap(10);
			centerPane.setAlignment(Pos.CENTER);
		label1 = new Label("Das ist ein Button:");
		button1 = new Button("Button 1");
		label2 = new Label("... ein weiterer Button ...");
		button2 = new Button("Button 2");
		label3 = new Label("... und noch ein Button ...");
		button3 = new Button("Button 3");
		label4 = new Label("... und da der letzte");
		button4 = new Button("Button 4");
		
		bottomPane = new FlowPane();
			bottomPane.setHgap(10);
			bottomPane.setAlignment(Pos.BOTTOM_RIGHT);
			bottomPane.setPadding(new Insets(10));
		buttonOk = new Button("OK");
			buttonOk.setPrefWidth(100);
		buttonAbbruch = new Button("Abbruch");
			buttonAbbruch.setPrefWidth(100);
	}

	private void addComponents()
	{
		ToggleGroup toggleGroup = new ToggleGroup();
		toggleGroup.getToggles().addAll(radioButton1, radioButton2, radioButton3);
		topPane.getChildren().addAll(labelRadioButton, radioButton1, radioButton2, radioButton3);
		
		centerPane.add(label1, 0, 0);
		centerPane.add(button1, 1, 0);
		centerPane.add(label2, 0, 1);
		centerPane.add(button2, 1, 1);
		centerPane.add(label3, 0, 2);
		centerPane.add(button3, 1, 2);
		centerPane.add(label4, 0, 3);
		centerPane.add(button4, 1, 3);
		
		bottomPane.getChildren().addAll(buttonOk, buttonAbbruch);
		
		setTop(topPane);
		setCenter(centerPane);
		setBottom(bottomPane);
	}

}



















