package application;

import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.control.Button;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;

public class RootGridPane extends GridPane
{
	private FlowPane flowPane;
	private Button button1, button2, button3, button4, button5, button6, button7;
	
	public RootGridPane()
	{
		initComponents();
		addComponents();
	}

	private void initComponents()
	{
		button1 = new Button("Susi");
		button2 = new Button("Hans");
		button3 = new Button("Alex");
		button4 = new Button("Max");
		button5 = new Button("Maria");
		button6 = new Button("Andrea");
		button7 = new Button("Maria");
		flowPane = new FlowPane();
		
		button1.setPrefSize(100, 100);
		GridPane.setHalignment(button1, HPos.CENTER);
		GridPane.setValignment(button1, VPos.BOTTOM);
		button1.setAlignment(Pos.BOTTOM_CENTER);
		button2.setPrefSize(200, 200);
		button3.setPrefSize(200, 200);
		button3.setAlignment(Pos.BOTTOM_LEFT);
		button4.setPrefWidth(90);
		button4.setPrefWidth(100);
		button4.setPrefWidth(80);
		
		flowPane.setPrefSize(200, 200);
		flowPane.setAlignment(Pos.CENTER_LEFT);
		flowPane.setPadding(new Insets(10));
		flowPane.setVgap(10);
		flowPane.setHgap(10);
	}

	private void addComponents()
	{
		flowPane.getChildren().addAll(button4, button5, button6, button7);
		add(button1, 0, 0);
		add(button2, 1, 0);
		add(button3, 0, 1);
		add(flowPane, 1, 1);
	}
}
