package model;

public class Vorstand extends Mitglied
{
	public Vorstand(String name, boolean aktiv, double gehalt) throws VereinException
	{
		super(name, aktiv);
		setGehalt(gehalt);
	}
	
	public Vorstand(String zeile) throws VereinException
	{
		//Vorstand,AlexNachmüller,a,80
		super(zeile);
		String[] eigenschaften;
		try
		{
			eigenschaften = zeile.split(",");
			setGehalt(Double.parseDouble(eigenschaften[3].trim()));
		}
		catch (ArrayIndexOutOfBoundsException e)
		{
			throw new VereinException("Zu wenig Attribute!");
		}
		catch (NumberFormatException e)
		{
			throw new VereinException("Kein gültiger Gehalt!");
		}
	}

	private double gehalt;

	public double getGehalt()
	{
		return gehalt;
	}
	
	public void setAktiv(boolean aktiv) throws VereinException
	{
		if (aktiv)
			super.setAktiv(aktiv);
		else
			throw new VereinException("Vorstand ist nicht aktiv!");
	}

	public void setGehalt(double gehalt) throws VereinException
	{
		if ((gehalt >= 0) && (gehalt <= 100))
			this.gehalt = gehalt;
		else
			throw new VereinException("Ungültiges Gehalt!");
	}
	
	public double einfordern()
	{
		return getVerein().getBeitrag()-gehalt;
	}
	
	public String toString()
	{
		return super.toString() + " " + (gehalt*12) + "€";
	}
	
	public String toStringCSV()
	{
		return "Vorstand," + super.toStringCSV() + "," + gehalt;
	}
}















