package model;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;

public class Verein
{
	private double beitrag;
	private HashMap<String, Mitglied> mitglieder;
	
	public Verein(double beitrag)
	{
		setBeitrag(beitrag);
		mitglieder = new HashMap<>();
	}
	
	public void exportVerein(String fileName) throws VereinException
	{
		FileWriter fw;
		BufferedWriter bw;
		
		try
		{
			fw = new FileWriter(fileName);
			bw = new BufferedWriter(fw);
			bw.write(toStringCSV());
			bw.close();
			fw.close();
		}
		catch (FileNotFoundException e)
		{
			throw new VereinException("Pfad nicht gefunden!");
		}
		catch (IOException e)
		{
			throw new VereinException("Datei konnte nicht beschrieben werden!");
		}
	}
	
	@SuppressWarnings("resource")
	public void importVerein(String fileName) throws VereinException
	{
		String zeile;
		FileReader fr;
		BufferedReader br;
		Vorstand v;
		RegularesMitglied r;
		
		try
		{
			fr = new FileReader(fileName);
			br = new BufferedReader(fr);
			zeile = br.readLine();
			while (zeile != null)
			{
				if (zeile.startsWith("Vorstand"))
				{
					v = new Vorstand(zeile);
					aufnehmen(v);
				}
				else
					if (zeile.startsWith("Regulär"))
					{
						r = new RegularesMitglied(zeile);
						aufnehmen(r);
					}
					else
						throw new VereinException("Ungültiges Objekt!");
				zeile = br.readLine();
			}
			br.close();
			fr.close();
		}
		catch (FileNotFoundException e)
		{
			throw new VereinException("Datei nicht vorhanden!");
		}
		catch (IOException e)
		{
			throw new VereinException("Datei konnte nicht gelesen werden!");
		}
	}
	
	public void aufnehmen(Mitglied mitglied) throws VereinException
	{
		if (mitglied != null)
		{
			if (! mitglieder.containsKey(mitglied.getName()))
			{
				mitglieder.put(mitglied.getName(), mitglied);
				mitglied.setVerein(this);
			}
			else
				throw new VereinException("Schon vorhanden!");
		}
		else
			throw new VereinException("Kein gültiges Mitglied!");
	}
	
	public double abkassieren()
	{
		double summe;
		
		summe = 0;
		for (Mitglied m : mitglieder.values())
		{
			summe += m.einfordern();
		}
		return summe;
	}
	
	public void rauswerfen()
	{
		Mitglied m;
		Iterator<Mitglied> it;
		it = mitglieder.values().iterator();
		while (it.hasNext())
		{
			m = it.next();
			if (m.isAktiv() == false)
			{
				it.remove();
			}
		}
	}

	public double getBeitrag()
	{
		return beitrag;
	}

	public void setBeitrag(double beitrag)
	{
		this.beitrag = beitrag;
	}
	
	public String toString()
	{
		String erg;
		
		erg = "";
		for (Mitglied m : mitglieder.values())
		{
			erg += m.toString() + "\n";
		}
		return erg;
	}

	public String toStringCSV()
	{
		String erg;
		
		erg = "";
		for (Mitglied m : mitglieder.values())
		{
			erg += m.toStringCSV() + "\n";
		}
		return erg;
	}
}

















