package model;

public abstract class Mitglied
{
	private Verein verein;
	private String name;
	private boolean aktiv;
	
	public Mitglied(String name, boolean aktiv) throws VereinException
	{
		setName(name);
		setAktiv(aktiv);
	}
	
	public Mitglied(String zeile) throws VereinException
	{
		//Vorstand,AlexNachmüller,a,80
		//Regulär,FritzMüller,n
		String[] eigenschaften;
		try
		{
			eigenschaften = zeile.split(",");
			setName(eigenschaften[1]);
			setAktiv(eigenschaften[2].startsWith("a"));
		}
		catch (ArrayIndexOutOfBoundsException e)
		{
			throw new VereinException("Zu wenig Attribute!");
		}
	}

	public Verein getVerein()
	{
		return verein;
	}

	public void setVerein(Verein verein)
	{
		this.verein = verein;
	}
	
	public String getName()
	{
		return name;
	}
	
	public void setName(String name) throws VereinException
	{
		if ((name != null) && (name.length() > 4))
		{
			this.name = name;
		}
		else
		{
			throw new VereinException("Ungültiger Name!");
		}
	}
	
	public boolean isAktiv()
	{
		return aktiv;
	}
	
	public void setAktiv(boolean aktiv) throws VereinException
	{
		this.aktiv = aktiv;
	}
	
	public String toString()
	{
		if (aktiv)
			return name + " (aktiv)";
		else
			return name + " (nicht aktiv)";
	}
	
	public String toStringCSV()
	{
		if (aktiv)
			return name + ",a";
		else
			return name + ",n";
	}

	public abstract double einfordern();
}

















