package model;

public class MietAuto extends Fahrzeug
{
	private double preisTag;

	public MietAuto(String kennzeichen, int km, double preisTag) throws FahrzeugException
	{
		super(kennzeichen, km);
		setPreisTag(preisTag);
	}

	public double getPreisTag()
	{
		return preisTag;
	}

	public void setPreisTag(double preisTag)
	{
		this.preisTag = preisTag;
	}
	
	@Override
	public double berechnePreis(int anzahl)
	{
		return anzahl * preisTag;
	}

	@Override
	public void erhoheKmStand(int tage) throws FahrzeugException
	{
		int km;
		
		km = 150*tage;
		super.erhoheKmStand(km);
	}
	
	@Override
	public String toString()
	{
		return super.toString() + " " + preisTag + " EUR/Tag";
	}
}
