package model;

public class Kunde
{
	private double geld;

	public Kunde(double geld) throws FahrzeugException
	{
		super();
		setGeld(geld);
	}

	public double getGeld()
	{
		return geld;
	}

	public void setGeld(double geld) throws FahrzeugException
	{
		if (geld >= 0)
			this.geld = geld;
		else
			throw new FahrzeugException("Fehler: kein negativer Geldbetrag möglich!");
	}

	public void bestelle(Fahrzeug welches, int anzahl) throws FahrzeugException
	{
		if (welches != null)
		{
			if (anzahl > 0)
			{
				if (geld >= welches.berechnePreis(anzahl))
				{
					welches.erhoheKmStand(anzahl);
					setGeld(geld - welches.berechnePreis(anzahl));
				}
				else
					throw new FahrzeugException("Fehler: zu wenig Geld!");
			}
			else
				throw new FahrzeugException("Fehler: mind. 1 km bzw. Tag!");
		}
		else
			throw new FahrzeugException("Fehler: kein " + getClass().getSimpleName() + "!");
	}

	
	/*
	public void bestelle(MietAuto welches, int anzahl) throws FahrzeugException
	{
		if (welches != null)
		{
			if (anzahl > 0)
			{
				if (geld >= welches.berechnePreis(anzahl))
				{
					welches.erhoheKmStand(anzahl);
					setGeld(geld - welches.berechnePreis(anzahl));
				}
				else
					throw new FahrzeugException("Fehler: zu wenig Geld!");
			}
			else
				throw new FahrzeugException("Fehler: mind. 1 Tag!");
		}
		else
			throw new FahrzeugException("Fehler: kein MietAuto!");
	}
	
	public void bestelle(Taxi welches, int anzahl) throws FahrzeugException
	{
		if (welches != null)
		{
			if (anzahl > 0)
			{
				if (geld >= welches.berechnePreis(anzahl))
				{
					welches.erhoheKmStand(anzahl);
					setGeld(geld - welches.berechnePreis(anzahl));
				}
				else
					throw new FahrzeugException("Fehler: zu wenig Geld!");
			}
			else
				throw new FahrzeugException("Fehler: mind. 1 km!");
		}
		else
			throw new FahrzeugException("Fehler: kein Taxi!");
	}
	 */
	@Override
	public String toString()
	{
		return "Kunde " + geld + " EUR";
	}
	
	
}
