package model;

public abstract class Fahrzeug                     // extends Object
{
	private static int    nextFahrzeugId = 1000;
	private        int    fahrzeugId;
	private        String kennzeichen;
	private        int    km;
	
	public Fahrzeug(String kennzeichen, int km) throws FahrzeugException
	{
		super();                         // Constructor of Object
		setFahrzeugId();
		setKennzeichen (kennzeichen);
		setKm (km);
	}

	public int getFahrzeugId()
	{
		return fahrzeugId;
	}

	public void setFahrzeugId()
	{
		nextFahrzeugId++;
		this.fahrzeugId = nextFahrzeugId;
	}

	public String getKennzeichen()
	{
		return kennzeichen;
	}
	
	public void setKennzeichen(String kennzeichen) throws FahrzeugException
	{
		if (kennzeichen != null)
			this.kennzeichen = kennzeichen;
		else
		{
			throw new FahrzeugException("Fehler: kein Kennzeichen!");
		}
	}
	
	public int getKm()
	{
		return km;
	}
	
	public void setKm(int km) throws FahrzeugException
	{
		if (km >= 0)
			this.km = km;
		else
		{
			throw new FahrzeugException("Fehler: negativer KM Stand!");
		}
	}
	
	public abstract double berechnePreis(int anzahl);
	
	public void erhoheKmStand(int km) throws FahrzeugException
	{
		if (km > 0)
		{
			this.km += km;
		}
		else
			throw new FahrzeugException("Fehler: Tacho darf nicht zurückgedreht werden!");
	}
	
	//012345678
	//WN-5466H      -> WN
	//W-34556E      -> W
	//BN-123123R    -> BN
	public String getOrt() throws FahrzeugException 
	{
		try
		{
			return kennzeichen.substring(0, kennzeichen.indexOf('-'));
		}
		catch (IndexOutOfBoundsException e)
		{
			throw new FahrzeugException("Fehler: beim Kennzeichen kein Ort angegeben!");
		}
	}

	//012345678
	//WN-5466H      -> 5466
	//W-34556E      -> 34556
	//BN-123123R    -> 123123
	//MD-
	public int getNummer() throws FahrzeugException
	{
		if (kennzeichen.contains("-"))
		{
			try
			{
				int s, e;
				String num;
				// Integer inum;
				s = kennzeichen.indexOf('-')+1;
				e = kennzeichen.length()-1;
				num = kennzeichen.substring(s,e);
				// inum = new Integer(num);
				// return inum.intValue();         NICHT static
				return Integer.parseInt(num);    //static
				
				// return Integer.parseInt(kennzeichen.substring(kennzeichen.indexOf('-')+1,kennzeichen.length()-1));				
			}
			catch (NumberFormatException e)
			{
				throw new FahrzeugException("Fehler: in der Nummer ist ein Buchstabe enthalten!");				
			}
			catch (IndexOutOfBoundsException e)
			{
				throw new FahrzeugException("Fehler: keine Nummer im Kennzeichen!");
			}
		}
		else
			throw new FahrzeugException("Fehler: beim Kennzeichen kein - vorhanden!");
	}

	
	
	@Override
	public String toString()
	{
		return getClass().getSimpleName() + " " + fahrzeugId + " " + kennzeichen + " " + km + " km ";
	}	
}
