package test;

import model.FahrzeugException;
import model.Kunde;
import model.Taxi;

public class TestKunde
{
	public static void main(String[] args)
	{
		testBestelleTaxi();
	}

	public static void testBestelleTaxi()
	{
		Taxi t;
		Kunde k;
		
		try                                               //OK
		{
			t = new Taxi("BN-3459R", 10000, 1.1);
			k = new Kunde(100);
			System.out.println(t);
			System.out.println(k);
			k.bestelle(t, 15);
			System.out.println(t);
			System.out.println(k);
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}
		
		try                                                //mind. 1 KM
		{
			t = new Taxi("BN-3459R", 10000, 1.1);
			k = new Kunde(100);
			k.bestelle(t, -15);
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}
		
		try                                                //kein Taxi
		{
			t = new Taxi("BN-3459R", 10000, 1.1);
			k = new Kunde(100);
			k.bestelle(null, 15);
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}
		
		try                                               //zu wenig Geld
		{
			t = new Taxi("BN-3459R", 10000, 1.1);
			k = new Kunde(100);
			k.bestelle(t, 900);
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}
	}

	public static void testConstructor()
	{
		Kunde k0, k1;
		
		try
		{
			k0 = new Kunde(50);
			System.out.println(k0);
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}
		try
		{
			k1 = new Kunde(-10);
			System.out.println(k1);
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}
	}
}
