package test;

import model.Fahrzeug;
import model.FahrzeugException;
import model.Taxi;

public class TestFahrzeug
{
	public static void main(String[] args)
	{
		testNummer();
	}

	public static void testNummer()
	{
		Fahrzeug f0, f1, f2, f3, f4, f5;
		
		try
		{
			f0 = new Taxi("BN-234D", 10, 2);
			System.out.println(f0);              // BN-2345D 0
			System.out.println(f0.getNummer());  // 2345D
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}          

		try
		{
			f1 = new Taxi("W-78934T", 0, 2);
			System.out.println(f1);              // W-78934T 0
			System.out.println(f1.getNummer());  // 78934T
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}          

		try
		{
			f2 = new Taxi("MAUSI1", 0, 2);
			System.out.println(f2);              // MAUSI1 0
			System.out.println(f2.getNummer());  // ???
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}          		

		try
		{
			f3 = new Taxi("MD-", 0, 2);
			System.out.println(f3);              // MD- 0
			System.out.println(f3.getNummer());  // ???
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}          		

		try
		{
			f4 = new Taxi("", 0, 2);
			System.out.println(f4);              //  0
			System.out.println(f4.getNummer());  // ???
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}          		

		try
		{
			f5 = new Taxi("WN-3456HH", 0, 2);
			System.out.println(f5);
			System.out.println(f5.getNummer());  // 3456H
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}    		
	}
	
	public static void testGetOrt()
	{
		Fahrzeug f0, f1, f2, f3;
		
		try
		{
			f0 = new Taxi("BN-234D", 10, 2);
			System.out.println(f0);              // BN-2345D 0
			System.out.println(f0.getOrt());     // BN
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}          

		try
		{
			f1 = new Taxi("W-78934T", 0, 2);
			System.out.println(f1);              // W-78934T 0
			System.out.println(f1.getOrt());     // W
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}          

		try
		{
			f2 = new Taxi("MAUSI1", 0, 2);
			System.out.println(f2);              // MAUSI1 0
			System.out.println(f2.getOrt());     // ???
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}          
	}

	public static void testConstructor()
	{
		Fahrzeug f0, f1, f2, f3;
		
		try
		{
			f0 = new Taxi(null, 0, 2);
			System.out.println(f0);
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());  // Fehler: kein Kennzeichen!
		}          

		try
		{
			f1 = new Taxi("WN-7777V",   0, 2);  
			System.out.println(f1);              // WN-7777V 0
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}   
		
		try
		{
			f2 = new Taxi("WN-8888V", -20, 2);
			System.out.println(f2);
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());  // Fehler: negativer KM Stand
		}   		
		
		try
		{
			f3 = new Taxi("WN-9999V", 200, 2);
			System.out.println(f3);              // WN-9999V 200
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}   		
	}
}
