package model;

public class Taxi extends Fahrzeug
{
	private double preisKm;
	private final static double minPreisKm = 0.5;
	private final static double maxPreisKm = 2;

	public Taxi(String kennzeichen, int km, double preisKm) throws FahrzeugException
	{
		super(kennzeichen, km);
		setPreisKm (preisKm);
	}

	public static double getMaxPreisKm()
	{
		return maxPreisKm;
	}
	
	public double getPreisKm()
	{
		return preisKm;
	}

	public void setPreisKm(double preisKm) throws FahrzeugException
	{
		if ((preisKm >= minPreisKm) && (preisKm <= maxPreisKm))
			this.preisKm = preisKm;
		else
			throw new FahrzeugException("Fehler: km Preis muss zwischen " + minPreisKm + " und " + maxPreisKm + " EUR sein!");
	}

	@Override
	public String toString()
	{
		return super.toString() + preisKm + " EUR";
	}
}
