package model;

public class Kunde
{
	private double geld;

	public Kunde(double geld) throws FahrzeugException
	{
		super();
		setGeld(geld);
	}

	public double getGeld()
	{
		return geld;
	}

	public void setGeld(double geld) throws FahrzeugException
	{
		if (geld >= 0)
			this.geld = geld;
		else
			throw new FahrzeugException("Fehler: kein negativer Geldbetrag möglich!");
	}
	
	public void bestelleMietAuto(MietAuto welches, int tage)
	{
		// pro Tag werden 150 KM gefahren!!!
	}
	
	public void bestelleTaxi(Taxi welches, int km) throws FahrzeugException
	{
		int neuKm;
		double zahlen;

		if (welches != null)
		{
			if (km > 0)
			{
				if (geld >= km * welches.getPreisKm())
				{
					neuKm = welches.getKm() + km;
					welches.setKm(neuKm);
					zahlen = km * welches.getPreisKm();
					setGeld(geld - zahlen);
				}
				else
					throw new FahrzeugException("Fehler: zu wenig Geld!");
			}
			else
				throw new FahrzeugException("Fehler: mind. 1 km!");
		}
		else
			throw new FahrzeugException("Fehler: kein Taxi!");
	}

	@Override
	public String toString()
	{
		return "Kunde " + geld + " EUR";
	}
	
	
}
