package test;

import model.Fahrzeug;
import model.FahrzeugException;

public class TestFahrzeug
{
	public static void main(String[] args)
	{
		testGetOrt();
	}

	public static void testGetOrt()
	{
		Fahrzeug f0, f1, f2, f3;
		
		try
		{
			f0 = new Fahrzeug("BN-2345D", 0);
			System.out.println(f0);              // BN-2345D 0
			System.out.println(f0.getOrt());     // BN
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}          

		try
		{
			f1 = new Fahrzeug("W-78934T", 0);
			System.out.println(f1);              // W-78934T 0
			System.out.println(f1.getOrt());     // W
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}          

		try
		{
			f2 = new Fahrzeug("MAUSI1", 0);
			System.out.println(f2);              // MAUSI1 0
			System.out.println(f2.getOrt());     // ???
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}          
	}

	public static void testConstructor()
	{
		Fahrzeug f0, f1, f2, f3;
		
		try
		{
			f0 = new Fahrzeug(null, 0);
			System.out.println(f0);
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());  // Fehler: kein Kennzeichen!
		}          

		try
		{
			f1 = new Fahrzeug("WN-7777V",   0);  
			System.out.println(f1);              // WN-7777V 0
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}   
		
		try
		{
			f2 = new Fahrzeug("WN-8888V", -20);
			System.out.println(f2);
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());  // Fehler: negativer KM Stand
		}   		
		
		try
		{
			f3 = new Fahrzeug("WN-9999V", 200);
			System.out.println(f3);              // WN-9999V 200
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}   		
	}
}
