package model;

public class Taxi extends Fahrzeug
{
	private double preisKm;

	public Taxi(String kennzeichen, int km, double preisKm) throws FahrzeugException
	{
		super(kennzeichen, km);
		setPreisKm (preisKm);
	}

	public double getPreisKm()
	{
		return preisKm;
	}

	public void setPreisKm(double preisKm) throws FahrzeugException
	{
		if ((preisKm > 0.5) && (preisKm < 2))
			this.preisKm = preisKm;
		else
			throw new FahrzeugException("Fehler: km Preis muss zwischen 0.5 und 2 EUR sein!");
	}

	@Override
	public String toString()
	{
		return super.toString() + preisKm + " EUR";
	}
}
