package model;

public class Fahrzeug                     // extends Object
{
	private String kennzeichen;
	private int    km;
	
	public Fahrzeug(String kennzeichen, int km) throws FahrzeugException
	{
		super();                         // Constructor of Object
		setKennzeichen (kennzeichen);
		setKm (km);
	}

	public String getKennzeichen()
	{
		return kennzeichen;
	}
	
	public void setKennzeichen(String kennzeichen) throws FahrzeugException
	{
		if (kennzeichen != null)
			this.kennzeichen = kennzeichen;
		else
		{
			throw new FahrzeugException("Fehler: kein Kennzeichen!");
		}
	}
	
	public int getKm()
	{
		return km;
	}
	
	public void setKm(int km) throws FahrzeugException
	{
		if (km >= 0)
			this.km = km;
		else
		{
			throw new FahrzeugException("Fehler: negativer KM Stand!");
		}
	}
	
	//012345678
	//WN-5466H      -> WN
	//W-34556E      -> W
	//BN-123123R    -> BN
	public String getOrt() throws FahrzeugException 
	{
		try
		{
			return kennzeichen.substring(0, kennzeichen.indexOf('-'));
		}
		catch (IndexOutOfBoundsException e)
		{
			throw new FahrzeugException("Fehler: beim Kennzeichen kein Ort angegeben!");
		}
	}
	
	@Override
	public String toString()
	{
		return getClass().getSimpleName() + " " + kennzeichen + " " + km + " km ";
	}	
}
