package test;

import model.Anhanger;
import model.FahrzeugException;
import model.LKW;
import model.Spedition;

public class TestSpedition
{

	public static void main(String[] args)
	{
		testExportFahrzeuge();
	}

	public static void testExportFahrzeuge()
	{
		Spedition s;
		
		try
		{
			s = new Spedition("Rasch und Schnell!");
			s.importFahrzeuge("fahrzeuge.txt");
			s.exportFahrzeuge("fahrzeuge2.txt");			
			System.out.println(s);
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}
	}
	
	public static void testImportFahrzeuge()
	{
		Spedition s;
		
		try
		{
			s = new Spedition("Rasch und Schnell!");
			s.importFahrzeuge("fahrzeuge.txt");
			System.out.println(s);
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}
	}
	
	public static void testLoadFahrzeuge()
	{
		Spedition s;
		
		try
		{
			s = new Spedition("Rasch und Schnell!");
			s.loadFahrzeuge("fahrzeuge.ser");
			System.out.println(s);
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}
	}

	public static void testSaveFahrzeuge()
	{
		Spedition s;
		LKW l0, l1, l2, l3, l4, l5, l6;
		
		try
		{
			s = new Spedition("Rasch und Schnell!");
			l0 = new LKW("BN-12345R",  2019, 1000, 2300);
			l1 = new LKW("W-69424W",   1990, 1500, 4000, new Anhanger(900, 1500));
			l2 = new LKW("BN-5633W",   1995, 1800, 3500);
			l3 = new LKW("W-1112E",    2000, 1000, 2900, new Anhanger(700, 1200));
			l4 = new LKW("W-4321W",    2001, 1200, 2700, new Anhanger(950, 1400));
			l5 = new LKW("WN-23012Q",  2005, 1200, 3500);
			l6 = new LKW("BN-54321R",  2015, 1000, 2300);
			s.hinzufugen(l0);
			s.hinzufugen(l1);
			s.hinzufugen(l2);
			s.hinzufugen(l3);
			s.hinzufugen(l4);
			s.hinzufugen(l5);
			s.hinzufugen(l6);
			System.out.println(s);
			System.out.println("=======================");
			s.saveFahrzeuge("fahrzeuge.ser");
			s.saveFahrzeuge("/gibtsnicht/fahrzeuge2.ser");
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}
	}

	
	public static void testSortKennzeichen()
	{
		Spedition s;
		LKW l0, l1, l2, l3, l4, l5, l6;
		
		try
		{
			s = new Spedition("Rasch und Schnell!");
			l0 = new LKW("BN-12345R",  2019, 1000, 2300);
			l1 = new LKW("W-69424W",   1990, 1500, 4000, new Anhanger(900, 1500));
			l2 = new LKW("BN-5633W",   1995, 1800, 3500);
			l3 = new LKW("W-1112E",    2000, 1000, 2900, new Anhanger(700, 1200));
			l4 = new LKW("W-4321W",    2001, 1200, 2700, new Anhanger(950, 1400));
			l5 = new LKW("WN-23012Q",  2005, 1200, 3500);
			l6 = new LKW("BN-54321R",  2015, 1000, 2300);
			s.hinzufugen(l0);
			s.hinzufugen(l1);
			s.hinzufugen(l2);
			s.hinzufugen(l3);
			s.hinzufugen(l4);
			s.hinzufugen(l5);
			s.hinzufugen(l6);
			System.out.println(s);
			System.out.println("=======================");
			s.sortKennzeichen();
			System.out.println(s);
			System.out.println("=======================");
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}
	}

	
	public static void testSortNutzlast()
	{
		Spedition s;
		LKW l0, l1, l2, l3, l4, l5, l6;
		
		try
		{
			s = new Spedition("Rasch und Schnell!");
			l0 = new LKW("BN-12345R",  2019, 1000, 2300);
			l1 = new LKW("W-69424W",   1990, 1500, 4000, new Anhanger(900, 1500));
			l2 = new LKW("BN-5633W",   1995, 1800, 3500);
			l3 = new LKW("W-1112E",    2000, 1000, 2900, new Anhanger(700, 1200));
			l4 = new LKW("W-4321W",    2001, 1200, 2700, new Anhanger(950, 1400));
			l5 = new LKW("WN-23012Q",  2005, 1200, 3500);
			l6 = new LKW("BN-54321R",  2015, 1000, 2300);
			s.hinzufugen(l0);
			s.hinzufugen(l1);
			s.hinzufugen(l2);
			s.hinzufugen(l3);
			s.hinzufugen(l4);
			s.hinzufugen(l5);
			s.hinzufugen(l6);
			System.out.println(s);
			System.out.println("=======================");
			s.sortNutzlast();
			System.out.println(s);
			System.out.println("=======================");
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}
	}

	
	public static void testLoscheFahrzeug()
	{
		Spedition s;
		LKW l0, l1, l2, l3, l4, l5;
		
		try
		{
			s = new Spedition("Rasch und Schnell!");
			l0 = new LKW("BN-345532R", 2019, 1000, 2300);
			l1 = new LKW("W-69424W",   1990, 1500, 4000, new Anhanger(900, 1500));
			l2 = new LKW("BN-5633W",   1995, 1800, 3500);
			l3 = new LKW("W-1112E",    2000, 1000, 2900, new Anhanger(700, 1200));
			l4 = new LKW("W-4321W",    2001, 1200, 2700, new Anhanger(950, 1400));
			l5 = new LKW("WN-23012Q",  2005, 1200, 3500);
			s.hinzufugen(l0);
			s.hinzufugen(l1);
			s.hinzufugen(l2);
			s.hinzufugen(l3);
			s.hinzufugen(l4);
			s.hinzufugen(l5);
			System.out.println(s);
			System.out.println("=======================");
			s.loscheFahrzeug("MD");
			System.out.println(s);
			s.loscheFahrzeug("W");
			System.out.println(s);
			System.out.println("=======================");
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}
	}
	
	public static void testGetAltestesFahrzeug()
	{
		Spedition s;
		LKW l0, l1, l2, l3, l4, l5;
		
		try
		{
			s = new Spedition("Rasch und Schnell!");
			l0 = new LKW("BN-345532R", 2019, 1000, 2300);
			l1 = new LKW("W-69424W",   1990, 1500, 4000, new Anhanger(900, 1500));
			l2 = new LKW("BN-5633W",   1995, 1800, 3500);
			l3 = new LKW("W-1112E",    2000, 1000, 2900, new Anhanger(700, 1200));
			l4 = new LKW("W-4321W",    2001, 1200, 2700, new Anhanger(950, 1400));
			l5 = new LKW("WN-23012Q",  2005, 1200, 3500);
			System.out.println(s.getAltestesFahrzeug());   //null
			s.hinzufugen(l0);
			s.hinzufugen(l1);
			s.hinzufugen(l2);
			s.hinzufugen(l3);
			s.hinzufugen(l4);
			s.hinzufugen(l5);
			System.out.println(s);
			System.out.println(s.getAltestesFahrzeug());   //"W-69424W",   1990, 1500, 4000
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}
	}
	
	public static void testAnzahlAlter()
	{
		Spedition s;
		LKW l0, l1, l2, l3, l4, l5;
		
		try
		{
			s = new Spedition("Rasch und Schnell!");
			l0 = new LKW("BN-345532R", 2019, 1000, 2300);
			l1 = new LKW("W-69424W",   1990, 1500, 4000, new Anhanger(900, 1500));
			l2 = new LKW("BN-5633W",   1995, 1800, 3500);
			l3 = new LKW("W-1112E",    2000, 1000, 2900, new Anhanger(700, 1200));
			l4 = new LKW("W-4321W",    2001, 1200, 2700, new Anhanger(950, 1400));
			l5 = new LKW("WN-23012Q",  2005, 1200, 3500);
			s.hinzufugen(l0);
			s.hinzufugen(l1);
			s.hinzufugen(l2);
			s.hinzufugen(l3);
			s.hinzufugen(l4);
			s.hinzufugen(l5);
			System.out.println(s);
			System.out.println(s.anzahlAlter(2000));   //2
			System.out.println(s.anzahlAlter(2020));   //6
			System.out.println(s.anzahlAlter(1990));   //0
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}
	}
	
	public static void testHinzufugen()
	{
		Spedition s;
		LKW l0;
		
		try
		{
			s = new Spedition("Rasch und Schnell!");
			l0 = new LKW("BN-345532R", 2019, 1000, 2300);
			s.hinzufugen(l0);
			System.out.println(s);
			s.hinzufugen(null);
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}
		
	}
	
	public static void testToString()
	{
		Spedition s;
		LKW l0, l1, l2, l3, l4, l5;
		
		try
		{
			s = new Spedition("Rasch und Schnell!");
			l0 = new LKW("BN-345532R", 2019, 1000, 2300);
			l1 = new LKW("W-69424W",   1990, 1500, 4000, new Anhanger(900, 1500));
			l2 = new LKW("BN-5633W",   1995, 1800, 3500);
			l3 = new LKW("W-1112E",    2000, 1000, 2900, new Anhanger(700, 1200));
			l4 = new LKW("W-4321W",    2001, 1200, 2700, new Anhanger(950, 1400));
			l5 = new LKW("WN-23012Q",  2005, 1200, 3500);
			s.hinzufugen(l0);
			s.hinzufugen(l1);
			s.hinzufugen(l2);
			s.hinzufugen(l3);
			s.hinzufugen(l4);
			s.hinzufugen(l5);
			System.out.println(s);
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}
	}
}
