package test;

import model.Anhanger;
import model.FahrzeugException;
import model.LKW;

public class TestFahrzeug
{
	public static void main(String[] args)
	{
		testGewicht();
	}

	public static void testGewicht()
	{
		LKW l0, l1;
		
		try
		{
			l0 = new LKW("BN-123456T", 2000, 1000, 1500);
			System.out.println(l0);                      //BN-123456T ...
			System.out.println("Eigen: " + l0.berechneEigengewicht());
			System.out.println("Nutz:  " + l0.berechneNutzlast());
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}		
		try
		{
			l1 = new LKW("W-44444T", 2000, 1200, 2000, new Anhanger(600, 1000));
			System.out.println(l1);                      //W-44444T ...
			System.out.println("Eigen: " + l1.berechneEigengewicht());
			System.out.println("Nutz:  " + l1.berechneNutzlast());
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}		
		
	}
	
	public static void testLKW()
	{
		LKW l0, l1, l2, l3;
		
		try
		{
			l0 = new LKW("BN-123456T", 2000, 1000, 1500);
			System.out.println(l0);                      //BN-123456T ...
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}
		try
		{
			l1 = new LKW("BN-123456T", 2000, 999, 1500);
			System.out.println(l1);
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());        //Fehler: ungültiges Eigengew.
		}
		try
		{
			l2 = new LKW("BN-123456T", 2000, 1000, 1499);
			System.out.println(l2);
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());        //Fehler: ungültiges Ges.gew.
		}
		try
		{
			l3 = new LKW("I-34543E", 2019, 1200, 3000, new Anhanger(500, 1000));
			System.out.println(l3);                      //I-34543E ... 500 1000
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}

	}
	
	public static void testFahrzeug()
	{
		LKW f0, f1, f2, f3, f4;
		
		try
		{
			f0 = new LKW("WN-45678A", 2000, 1200, 1600);
			System.out.println(f0);              //WN-45678A 2000
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage());
		}
		try
		{
			f1 = new LKW(null, 2000, 1200, 1600);
			System.out.println(f1);
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage()); //Fehler: ungültiges Kennzeichen!
		}
		try
		{
			f2 = new LKW("WN-2", 2000, 1200, 1600);
			System.out.println(f2);
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage()); //Fehler: ungültiges Kennzeichen!
		}
		try
		{
			f3 = new LKW("WN-5678Q", 1979, 1200, 1600);
			System.out.println(f3);
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage()); //Fehler: ungültiges Baujahr!
		}
		try
		{
			f4 = new LKW("WN-5678Q", 2021, 1200, 1600);
			System.out.println(f4);
		}
		catch (FahrzeugException e)
		{
			System.out.println(e.getMessage()); //Fehler: ungültiges Baujahr!
		}
	}
	
}
