package model;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class Spedition
{
	private String firmenName;
	private ArrayList<Fahrzeug> fahrzeuge;
	
	public Spedition(String firmenName)
	{
		setFirmenName (firmenName);
		fahrzeuge = new ArrayList<Fahrzeug>(20);
	}

	public String getFirmenName()
	{
		return firmenName;
	}
	
	public void setFirmenName(String firmenName)
	{
		this.firmenName = firmenName;
	}
	
	public void hinzufugen(Fahrzeug neu) throws FahrzeugException
	{
		if (neu != null)
		{
			fahrzeuge.add(neu);
		}
		else
		{
			throw new FahrzeugException("Fehler: klein Fahrzeug!");
		}
	}
	
	public int anzahlAlter(int baujahr)
	{
		int anz;
		
		anz = 0;
		for (Fahrzeug f: fahrzeuge)
		{
			if (f.getBaujahr() < baujahr)
			{
				anz++;
			}
		}
		return anz;
	}
	
	public Fahrzeug getAltestesFahrzeug()
	{
		int minBaujahr;
		Fahrzeug altesFahrzeug;
		
		minBaujahr = 9999;
		altesFahrzeug = null;
		for (Fahrzeug f: fahrzeuge)
		{
			if (minBaujahr > f.getBaujahr())
			{
				minBaujahr = f.getBaujahr();
				altesFahrzeug = f;
			}
		}
		return altesFahrzeug;
	}
	
	public void loscheFahrzeug(String stadt)
	{
		Iterator<Fahrzeug> iterator;
		Fahrzeug fahrzeug;
		
		iterator = fahrzeuge.iterator();
		while (iterator.hasNext())
		{
			fahrzeug = iterator.next();
			//W-456435W    W
			if (fahrzeug.getKennzeichen().toUpperCase().startsWith(stadt.toUpperCase()+"-"))
			{
				iterator.remove();
			}
		}
	}

	public void sortNutzlast()
	{
		Collections.sort(fahrzeuge);
	}
	
	public void sortKennzeichen()
	{
		Collections.sort(fahrzeuge, new Fahrzeug.KennzeichenComparator());
	}
	
	public void exportFahrzeuge(String filename) throws FahrzeugException
	{
		try
		{
			FileWriter fileWriter = new FileWriter(filename);
			BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
			bufferedWriter.write(toStringCSV());
			bufferedWriter.close();
			fileWriter.close();
		}
		catch (FileNotFoundException e)
		{
			throw new FahrzeugException("Fehler: Datei oder Pfad nicht gefunden!");
		}
		catch (IOException e)
		{
			//System.out.println(e);
			throw new FahrzeugException("Fehler: Datei konnte nicht geschrieben werden!");
		}
	}
	
	public void importFahrzeuge(String filename) throws FahrzeugException
	{
		try
		{
			String zeile;
			FileReader fileReader = new FileReader(filename);
			BufferedReader bufferedReader = new BufferedReader(fileReader);
			zeile = bufferedReader.readLine();
			while (zeile != null)
			{
				LKW l = new LKW(zeile);
				hinzufugen(l);
				zeile = bufferedReader.readLine();
			}
			bufferedReader.close();
			fileReader.close();
		}
		catch (FileNotFoundException e)
		{
			throw new FahrzeugException("Fehler: Datei oder Pfad nicht gefunden!");
		}
		catch (IOException e)
		{
			//System.out.println(e);
			throw new FahrzeugException("Fehler: Datei konnte nicht gelesen werden!");
		}
	}
	
	public void saveFahrzeuge(String filename) throws FahrzeugException
	{
		try
		{
			FileOutputStream fileOutputStream = new FileOutputStream(filename);
			ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
			objectOutputStream.writeObject(fahrzeuge);
			objectOutputStream.close();
			fileOutputStream.close();
		}
		catch (FileNotFoundException e)
		{
			throw new FahrzeugException("Fehler: Datei oder Pfad nicht gefunden!");
		}
		catch (IOException e)
		{
			//System.out.println(e);
			throw new FahrzeugException("Fehler: Datei konnte nicht geschrieben werden!");
		}
	}
	
	public void loadFahrzeuge(String filename) throws FahrzeugException
	{
		try
		{
			FileInputStream fileInputStream = new FileInputStream(filename);
			ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
			fahrzeuge = (ArrayList<Fahrzeug>) objectInputStream.readObject();
			objectInputStream.close();
			fileInputStream.close();
		}		
		catch (FileNotFoundException e)
		{
			throw new FahrzeugException("Fehler: Datei oder Pfad nicht gefunden!");
		}
		catch (IOException e)
		{
			throw new FahrzeugException("Fehler: Datei konnte nicht gelesen werden!");
		}
		catch (ClassNotFoundException e)
		{
			throw new FahrzeugException("Fehler: Datei enthält keine Fahrzeuge!");
		}
	}
	
	@Override
	public String toString()
	{
		String erg;
		
		erg = firmenName + "\n\n";
		for (Fahrzeug f: fahrzeuge)
		{
			erg += f.toString() + "\n";
		}
		return erg;
	}
	
	public String toStringCSV()
	{
		String erg;
		
		erg = "";
		for (Fahrzeug f: fahrzeuge)
		{
			erg += f.toStringCSV() + "\n";
		}
		return erg;
	}	
}


















